/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class LetterSeparationFilter
implements ImageFilter<BufferedImage> {
    private BufferedImage originalImage;
    private BufferedImage filteredImage;

    @Override
    public BufferedImage apply(BufferedImage image) {
        int gray;
        this.originalImage = image;
        int width = this.originalImage.getWidth();
        int height = this.originalImage.getHeight();
        boolean[][] matrix = new boolean[width][height];
        this.filteredImage = new BufferedImage(width, height, this.originalImage.getType());
        int[] histogram = this.imageHistogram(this.originalImage);
        int totalNumberOfpixels = height * width;
        int threshold = this.threshold(histogram, totalNumberOfpixels);
        int black = 0;
        int white = 255;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                gray = new Color(this.originalImage.getRGB(i, j)).getRed();
                matrix[i][j] = gray <= threshold;
            }
        }
        int blackTreshold = this.letterThreshold(this.originalImage, matrix);
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                gray = new Color(this.originalImage.getRGB(i, j)).getRed();
                int alpha = new Color(this.originalImage.getRGB(i, j)).getAlpha();
                int newColor = gray > blackTreshold ? white : black;
                newColor = ImageUtilities.argbToColor(alpha, newColor, newColor, newColor);
                this.filteredImage.setRGB(i, j, newColor);
            }
        }
        return this.filteredImage;
    }

    public int[] imageHistogram(BufferedImage image) {
        int i;
        int[] histogram = new int[256];
        for (i = 0; i < histogram.length; ++i) {
            histogram[i] = 0;
        }
        for (i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                int gray;
                int n = gray = new Color(image.getRGB(i, j)).getRed();
                histogram[n] = histogram[n] + 1;
            }
        }
        return histogram;
    }

    public int letterThreshold(BufferedImage original, boolean[][] matrix) {
        double sum = 0.0;
        int count = 0;
        for (int i = 0; i < original.getWidth(); ++i) {
            for (int j = 0; j < original.getHeight(); ++j) {
                if (!matrix[i][j]) continue;
                int gray = new Color(original.getRGB(i, j)).getRed();
                sum += (double)gray;
                ++count;
            }
        }
        if (count == 0) {
            return 0;
        }
        return (int)Math.round(sum * 3.0 / (double)(count * 2));
    }

    private int threshold(int[] histogram, int total) {
        float sum = 0.0f;
        for (int i = 0; i < 256; ++i) {
            sum += (float)(i * histogram[i]);
        }
        float sumB = 0.0f;
        int wB = 0;
        int wF = 0;
        float varMax = 0.0f;
        int threshold = 0;
        for (int i = 0; i < 256; ++i) {
            float mF;
            float varBetween;
            if ((wB += histogram[i]) == 0) continue;
            wF = total - wB;
            if (wF == 0) break;
            float mB = (sumB += (float)(i * histogram[i])) / (float)wB;
            if (!((varBetween = (float)wB * (float)wF * (mB - (mF = (sum - sumB) / (float)wF)) * (mB - mF)) > varMax)) continue;
            varMax = varBetween;
            threshold = i;
        }
        return threshold;
    }

    public int numberOfBlackPixels(boolean[][] matrix) {
        int count = 0;
        for (int x = 0; x < this.originalImage.getWidth(); ++x) {
            for (int y = 0; y < this.originalImage.getHeight(); ++y) {
                if (matrix[x][y]) continue;
                ++count;
            }
        }
        return count;
    }

    public String toString() {
        return "Letter Separation Filter";
    }
}

