/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class GrayscaleFilter
implements ImageFilter<BufferedImage>,
Serializable {
    private transient BufferedImage originalImage;
    private transient BufferedImage filteredImage;

    @Override
    public BufferedImage apply(BufferedImage image) {
        this.originalImage = image;
        int width = this.originalImage.getWidth();
        int height = this.originalImage.getHeight();
        this.filteredImage = new BufferedImage(width, height, this.originalImage.getType());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int alpha = new Color(this.originalImage.getRGB(x, y)).getAlpha();
                int red = new Color(this.originalImage.getRGB(x, y)).getRed();
                int green = new Color(this.originalImage.getRGB(x, y)).getGreen();
                int blue = new Color(this.originalImage.getRGB(x, y)).getBlue();
                int gray = (int)(0.21 * (double)red + 0.71 * (double)green + 0.07 * (double)blue);
                gray = ImageUtilities.argbToColor(alpha, gray, gray, gray);
                this.filteredImage.setRGB(x, y, gray);
            }
        }
        return this.filteredImage;
    }

    public String toString() {
        return "Grayscale Filter";
    }
}

