/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec.filter.impl;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import org.neuroph.imgrec.ImageUtilities;
import org.neuroph.imgrec.filter.ImageFilter;

public class AdaptiveThresholdBinarizeFilter
implements ImageFilter<BufferedImage>,
Serializable {
    private transient BufferedImage originalImage;
    private transient BufferedImage filteredImage;
    private int windowSize = 31;
    private double k = 0.02;

    @Override
    public BufferedImage apply(BufferedImage image) {
        int i;
        this.originalImage = image;
        int width = this.originalImage.getWidth();
        int height = this.originalImage.getHeight();
        this.filteredImage = new BufferedImage(width, height, this.originalImage.getType());
        double[][] G = new double[width][height];
        double gray = new Color(this.originalImage.getRGB(0, 0)).getRed();
        G[0][0] = gray / 255.0;
        for (i = 1; i < width; ++i) {
            gray = new Color(this.originalImage.getRGB(i, 0)).getRed();
            G[i][0] = G[i - 1][0] + gray / 255.0;
        }
        for (int j = 1; j < height; ++j) {
            gray = new Color(this.originalImage.getRGB(0, j)).getRed();
            G[0][j] = G[0][j - 1] + gray / 255.0;
        }
        for (i = 1; i < width; ++i) {
            for (int j = 1; j < height; ++j) {
                gray = new Color(this.originalImage.getRGB(i, j)).getRed();
                G[i][j] = gray / 255.0 + G[i][j - 1] + G[i - 1][j] - G[i - 1][j - 1];
            }
        }
        int d = this.windowSize / 2;
        int A = 0;
        int B = 0;
        int C = 0;
        int D = 0;
        for (int i2 = 0; i2 < width; ++i2) {
            for (int j = 0; j < height; ++j) {
                A = i2 + d - 1 >= width ? width - 1 : i2 + d - 1;
                B = j + d - 1 >= height ? height - 1 : j + d - 1;
                C = i2 - d < 0 ? 0 : i2 - d;
                D = j - d < 0 ? 0 : j - d;
                double s = G[A][B] + G[C][D] - (G[C][B] + G[A][D]);
                double m = s / (double)(this.windowSize * this.windowSize);
                gray = new Color(this.originalImage.getRGB(i2, j)).getRed();
                double delta = gray / 255.0 - m;
                double treshold = m * (1.0 + this.k * (delta / (1.0 - delta) - 1.0));
                int newColor = gray / 255.0 > treshold ? 255 : 0;
                int alpha = new Color(this.originalImage.getRGB(i2, j)).getAlpha();
                newColor = ImageUtilities.argbToColor(alpha, newColor, newColor, newColor);
                this.filteredImage.setRGB(i2, j, newColor);
            }
        }
        return this.filteredImage;
    }

    public void setK(double k) {
        this.k = k;
    }

    public void setWindowSize(int wSize) {
        this.windowSize = wSize;
    }

    public String toString() {
        return "Adaptive Treshold Binarize Filter";
    }
}

