/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.imgrec;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import org.neuroph.core.Neuron;
import org.neuroph.core.exceptions.VectorSizeMismatchException;
import org.neuroph.imgrec.ColorMode;
import org.neuroph.imgrec.FractionHSLData;
import org.neuroph.imgrec.FractionRgbData;
import org.neuroph.imgrec.ImageSampler;
import org.neuroph.imgrec.ImageSizeMismatchException;
import org.neuroph.imgrec.image.Dimension;
import org.neuroph.imgrec.image.Image;
import org.neuroph.imgrec.image.ImageFactory;
import org.neuroph.imgrec.image.ImageJ2SE;
import org.neuroph.util.plugins.PluginBase;

public class ImageRecognitionPlugin
extends PluginBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String IMG_REC_PLUGIN_NAME = "Image Recognition Plugin";
    private Dimension samplingResolution;
    private ColorMode colorMode;

    public ImageRecognitionPlugin(Dimension samplingResolution) {
        super(IMG_REC_PLUGIN_NAME);
        this.samplingResolution = samplingResolution;
        this.colorMode = ColorMode.COLOR_RGB;
    }

    public ImageRecognitionPlugin(Dimension samplingResolution, ColorMode colorMode) {
        super(IMG_REC_PLUGIN_NAME);
        this.samplingResolution = samplingResolution;
        this.colorMode = colorMode;
    }

    public Dimension getSamplingResolution() {
        return this.samplingResolution;
    }

    public ColorMode getColorMode() {
        return this.colorMode;
    }

    public void setInput(Image img) throws ImageSizeMismatchException {
        double[] input;
        FractionRgbData imgRgb;
        if (this.colorMode == ColorMode.COLOR_RGB) {
            imgRgb = new FractionRgbData(ImageSampler.downSampleImage(this.samplingResolution, img, img.getType()));
            input = imgRgb.getFlattenedRgbValues();
        } else if (this.colorMode == ColorMode.COLOR_HSL) {
            FractionHSLData imgHsl = new FractionHSLData(ImageSampler.downSampleImage(this.samplingResolution, img, img.getType()));
            input = imgHsl.getFlattenedHSLValues();
        } else if (this.colorMode == ColorMode.BLACK_AND_WHITE) {
            imgRgb = new FractionRgbData(ImageSampler.downSampleImage(this.samplingResolution, img, img.getType()));
            input = FractionRgbData.convertRgbInputToBinaryBlackAndWhite(imgRgb.getFlattenedRgbValues());
        } else {
            throw new RuntimeException("Unknown color mode!");
        }
        try {
            this.getParentNetwork().setInput(input);
        }
        catch (VectorSizeMismatchException vsme) {
            throw new ImageSizeMismatchException(vsme);
        }
    }

    public void setInput(File imgFile) throws IOException, ImageSizeMismatchException {
        this.setInput(ImageFactory.getImage(imgFile));
    }

    public void setInput(URL imgURL) throws IOException, ImageSizeMismatchException {
        this.setInput(ImageFactory.getImage(imgURL));
    }

    public void processInput() {
        this.getParentNetwork().calculate();
    }

    public HashMap<String, Double> getOutput() {
        HashMap<String, Double> networkOutput = new HashMap<String, Double>();
        for (Neuron neuron : this.getParentNetwork().getOutputNeurons()) {
            String neuronLabel = neuron.getLabel();
            networkOutput.put(neuronLabel, neuron.getOutput());
        }
        return networkOutput;
    }

    public HashMap<String, Double> recognizeImage(Image img) throws ImageSizeMismatchException {
        this.setInput(img);
        this.processInput();
        return this.getOutput();
    }

    public HashMap<String, Double> recognizeImage(BufferedImage img) throws ImageSizeMismatchException {
        return this.recognizeImage(new ImageJ2SE(img));
    }

    public HashMap<String, Double> recognizeImage(File imgFile) throws IOException, ImageSizeMismatchException {
        this.setInput(imgFile);
        this.processInput();
        return this.getOutput();
    }

    public HashMap<String, Double> recognizeImage(URL imgURL) throws IOException, ImageSizeMismatchException {
        this.setInput(imgURL);
        this.processInput();
        return this.getOutput();
    }

    public HashMap<String, Neuron> getMaxOutput() {
        HashMap<String, Neuron> maxOutput = new HashMap<String, Neuron>();
        Neuron maxNeuron = (Neuron)this.getParentNetwork().getOutputNeurons().get(0);
        for (Neuron neuron : this.getParentNetwork().getOutputNeurons()) {
            if (!(neuron.getOutput() > maxNeuron.getOutput())) continue;
            maxNeuron = neuron;
        }
        maxOutput.put(maxNeuron.getLabel(), maxNeuron);
        for (Neuron neuron : this.getParentNetwork().getOutputNeurons()) {
            if (neuron.getOutput() != maxNeuron.getOutput()) continue;
            maxOutput.put(neuron.getLabel(), neuron);
        }
        return maxOutput;
    }
}

