/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.rnn.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jblas.DoubleMatrix;
import org.neuroph.core.data.DataSet;

public class SequenceModeller {
    private final Map<String, Integer> charIndex = new HashMap<String, Integer>();
    private final Map<Integer, String> indexChar = new HashMap<Integer, String>();
    private final Map<String, DoubleMatrix> charVector = new HashMap<String, DoubleMatrix>();
    private final List<String> sequence = new ArrayList<String>();

    public SequenceModeller(DataSet dataSet) {
        this.loadData(dataSet);
        this.buildDistributedRepresentations();
    }

    private void loadData(DataSet dataSet) {
        List dataSetRows = dataSet.getRows();
        dataSetRows.forEach(row -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (double desiredOutput : row.getDesiredOutput()) {
                stringBuilder.append(desiredOutput);
                stringBuilder.append("");
            }
            String rowString = stringBuilder.toString();
            this.sequence.add(rowString);
            for (char c : rowString.toLowerCase().toCharArray()) {
                String key = String.valueOf(c);
                if (this.charIndex.containsKey(key)) continue;
                this.charIndex.put(key, this.charIndex.size());
                this.indexChar.put(this.charIndex.get(key), key);
            }
        });
    }

    private void buildDistributedRepresentations() {
        for (String key : this.charIndex.keySet()) {
            DoubleMatrix timestepInput = DoubleMatrix.zeros((int)1, (int)this.charIndex.size());
            timestepInput.put(this.charIndex.get(key).intValue(), 1.0);
            this.charVector.put(key, timestepInput);
        }
    }

    public Map<String, Integer> getCharIndex() {
        return this.charIndex;
    }

    public Map<String, DoubleMatrix> getCharVector() {
        return this.charVector;
    }

    public List<String> getSequence() {
        return this.sequence;
    }

    public Map<Integer, String> getIndexChar() {
        return this.indexChar;
    }
}

