/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.rnn.util;

import java.util.Random;
import org.jblas.DoubleMatrix;

public class MatrixInitializer {
    private final Type type;
    private static final Random RANDOM = new Random();
    private double scale = 0.01;
    private double miu = 0.0;
    private double sigma = 0.01;

    public MatrixInitializer(Type type, double scale, double miu, double sigma) {
        this.type = type;
        this.scale = scale;
        this.miu = miu;
        this.sigma = sigma;
    }

    public DoubleMatrix uniform(int rows, int cols) {
        return DoubleMatrix.rand((int)rows, (int)cols).mul(2.0 * this.scale).sub(this.scale);
    }

    public DoubleMatrix gaussian(int rows, int cols) {
        DoubleMatrix matrix = new DoubleMatrix(rows, cols);
        for (int i = 0; i < matrix.length; ++i) {
            matrix.put(i, RANDOM.nextGaussian() * this.sigma + this.miu);
        }
        return matrix;
    }

    public Type getType() {
        return this.type;
    }

    public double getScale() {
        return this.scale;
    }

    public double getMiu() {
        return this.miu;
    }

    public double getSigma() {
        return this.sigma;
    }

    public static enum Type {
        Uniform,
        Gaussian;

    }
}

