/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.model.sampling;

import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.util.data.sample.Sampling;

public abstract class AbstractSampling
implements Sampling {
    protected final int numberOfSamples;

    public AbstractSampling(int numberOfSamples) {
        this.numberOfSamples = numberOfSamples;
    }

    public DataSet[] sample(DataSet dataSet) {
        this.populateInternalDataStructure(dataSet);
        DataSet[] dataSets = new DataSet[this.numberOfSamples];
        for (int i = 0; i < this.numberOfSamples; ++i) {
            dataSets[i] = this.createDataSetFold(dataSet);
        }
        return dataSets;
    }

    private DataSet createDataSetFold(DataSet dataSet) {
        DataSet foldSet = new DataSet(dataSet.getInputSize(), dataSet.getOutputSize());
        for (int j = 0; j < this.getSampleSize(); ++j) {
            foldSet.add(this.getNextDataSetRow());
        }
        return foldSet;
    }

    protected abstract int getSampleSize();

    protected abstract DataSetRow getNextDataSetRow();

    protected abstract void populateInternalDataStructure(DataSet var1);
}

