/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.licenceplaterecognition;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.sourceforge.javaocr.ocrPlugins.charExtractor.CharacterExtractor;
import org.neuroph.contrib.licenceplaterecognition.BinaryOps;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.imgrec.ColorMode;
import org.neuroph.imgrec.image.Dimension;
import org.neuroph.imgrec.image.Image;
import org.neuroph.imgrec.image.ImageJ2SE;
import org.neuroph.ocr.OcrPlugin;
import org.neuroph.util.plugins.PluginBase;

public class OcrDemo {
    private String textImageFile = "data/tablica.jpg";
    private String datasetImageFile = "data/svaslova.jpg";
    private String neuralNetworkFile = "data/mrezica.nnet";
    private String datasetOutputFile = "data/dataset";
    private String charOutputFile = "data";
    private NeuralNetwork nnet;
    private BufferedImage image;
    private String recognizedCharacters = "";

    public OcrDemo() {
    }

    public OcrDemo(BufferedImage licencePlateImage, NeuralNetwork neuralNetwork) {
        this.image = licencePlateImage;
        this.nnet = neuralNetwork;
    }

    public String getRecognizedCharacters() {
        return this.recognizedCharacters;
    }

    public File crop(BufferedImage image) {
        int upperLeftCornerx = Integer.MAX_VALUE;
        int upperLeftCornery = Integer.MAX_VALUE;
        int lowerRightCornerx = Integer.MIN_VALUE;
        int lowerRightCornery = Integer.MIN_VALUE;
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                if (image.getRGB(i, j) == Color.WHITE.getRGB() && i < upperLeftCornerx && j < upperLeftCornery || i <= upperLeftCornerx && j < upperLeftCornery || i < upperLeftCornerx && j <= upperLeftCornery) {
                    upperLeftCornerx = i;
                    upperLeftCornery = j;
                }
                if (image.getRGB(i, j) != Color.WHITE.getRGB() || !(i > lowerRightCornerx && j >= lowerRightCornery || i >= lowerRightCornerx && j > lowerRightCornery) && (i <= lowerRightCornerx || j < lowerRightCornery)) continue;
                lowerRightCornerx = i;
                lowerRightCornery = j;
            }
        }
        BufferedImage croppedImage = image.getSubimage(upperLeftCornerx, upperLeftCornery, lowerRightCornerx - upperLeftCornerx, lowerRightCornery - upperLeftCornery);
        File cropFile = new File("croppedimage.png");
        try {
            ImageIO.write((RenderedImage)croppedImage, "png", cropFile);
        }
        catch (IOException ex) {
            Logger.getLogger(OcrDemo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return cropFile;
    }

    public void run() {
        try {
            if (this.image == null) {
                this.image = ImageIO.read(new File(this.textImageFile));
            }
            this.image = BinaryOps.binary(this.textImageFile);
            File cropFile = this.crop(this.image);
            CharacterExtractor ce = new CharacterExtractor();
            File outputDirectory = new File(this.charOutputFile);
            ce.slice(cropFile, outputDirectory, 60, 60);
            ArrayList<BufferedImage> lista = new ArrayList<BufferedImage>();
            for (int i = 0; i <= 7; ++i) {
                File f = new File("data/char_" + i + ".png");
                BufferedImage bi = ImageIO.read(f);
                lista.add(bi);
            }
            if (this.nnet == null) {
                NeuralNetwork i = NeuralNetwork.createFromFile((String)this.neuralNetworkFile);
            }
            this.nnet.addPlugin((PluginBase)new OcrPlugin(new Dimension(10, 10), ColorMode.BLACK_AND_WHITE));
            OcrPlugin ocrPlugin = (OcrPlugin)this.nnet.getPlugin(OcrPlugin.class);
            for (int i = 0; i < lista.size(); ++i) {
                this.recognizedCharacters = this.recognizedCharacters + ocrPlugin.recognizeCharacter((Image)new ImageJ2SE((BufferedImage)lista.get(i))) + " ";
                System.out.print(ocrPlugin.recognizeCharacter((Image)new ImageJ2SE((BufferedImage)lista.get(i))) + " ");
            }
            this.recognizedCharacters.trim();
        }
        catch (IOException e) {
            System.out.println("Error reading dir: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        new OcrDemo().run();
    }
}

