/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.licenceplaterecognition;

import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.core.image.ConvertBufferedImage;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class BinaryOps {
    public static BufferedImage invertImage(String imageName) {
        BufferedImage inputFile = null;
        try {
            inputFile = ImageIO.read(new File(imageName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (int x = 0; x < inputFile.getWidth(); ++x) {
            for (int y = 0; y < inputFile.getHeight(); ++y) {
                int rgba = inputFile.getRGB(x, y);
                Color col = new Color(rgba, true);
                col = new Color(255 - col.getRed(), 255 - col.getGreen(), 255 - col.getBlue());
                inputFile.setRGB(x, y, col.getRGB());
            }
        }
        try {
            File outputFile = new File("blackandwhite.png");
            ImageIO.write((RenderedImage)inputFile, "png", outputFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return inputFile;
    }

    public static BufferedImage binary(String textImageFile) {
        BufferedImage image = UtilImageIO.loadImage((String)textImageFile);
        ImageFloat32 input = (ImageFloat32)ConvertBufferedImage.convertFromSingle((BufferedImage)image, null, ImageFloat32.class);
        ImageUInt8 binary = new ImageUInt8(input.width, input.height);
        ImageSInt32 label = new ImageSInt32(input.width, input.height);
        double threshold = GThresholdImageOps.computeOtsu((ImageSingleBand)input, (int)0, (int)256);
        ThresholdImageOps.threshold((ImageFloat32)input, (ImageUInt8)binary, (float)((float)threshold), (boolean)true);
        ImageUInt8 filtered = BinaryImageOps.erode8((ImageUInt8)binary, (int)1, null);
        filtered = BinaryImageOps.dilate8((ImageUInt8)filtered, (int)1, null);
        BufferedImage visualFiltered = VisualizeBinaryData.renderBinary((ImageUInt8)filtered, null);
        File charFile = new File("whiteandblack.png");
        try {
            ImageIO.write((RenderedImage)visualFiltered, "png", charFile);
        }
        catch (IOException ex) {
            Logger.getLogger(BinaryOps.class.getName()).log(Level.SEVERE, null, ex);
        }
        return BinaryOps.invertImage("whiteandblack.png");
    }
}

