/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.bpbench;

import java.util.ArrayList;
import java.util.List;
import org.neuroph.contrib.bpbench.TrainingResult;

public class TrainingStatistics {
    private int minIterations = Integer.MAX_VALUE;
    private int maxIterations = Integer.MIN_VALUE;
    private double meanIterations;
    private double stdIterations;
    private double minError = 2.147483647E9;
    private double maxError = -2.147483648E9;
    private double meanError;
    private double stdError;
    private List<TrainingResult> trainingResults = new ArrayList<TrainingResult>();

    public void addData(TrainingResult result) {
        if (result.getTrainingIterations() < this.minIterations) {
            this.minIterations = result.getTrainingIterations();
        }
        if (result.getTrainingIterations() > this.maxIterations) {
            this.maxIterations = result.getTrainingIterations();
        }
        if (result.getError() < this.minError) {
            this.minError = result.getError();
        }
        if (result.getError() > this.maxError) {
            this.maxError = result.getError();
        }
        this.trainingResults.add(result);
    }

    public void calculateParameters() {
        this.calculateMean();
        this.calculateStd();
    }

    private void calculateMean() {
        int sumIter = 0;
        double sumError = 0.0;
        for (int i = 0; i < this.trainingResults.size(); ++i) {
            sumError += this.trainingResults.get(i).getError();
            sumIter += this.trainingResults.get(i).getTrainingIterations();
        }
        this.meanError = sumError / (double)this.trainingResults.size();
        this.meanIterations = (double)sumIter / (double)this.trainingResults.size();
    }

    private void calculateStd() {
        if (this.meanError == 0.0 || this.meanIterations == 0.0) {
            this.calculateMean();
        }
        double sumError = 0.0;
        int sumIter = 0;
        for (TrainingResult trainingResult : this.trainingResults) {
            sumError += Math.pow(trainingResult.getError() - this.meanError, 2.0);
            sumIter = (int)((double)sumIter + Math.pow((double)trainingResult.getTrainingIterations() - this.meanIterations, 2.0));
        }
        this.stdError = Math.sqrt(sumError / (double)this.trainingResults.size());
        this.stdIterations = Math.sqrt(sumIter / this.trainingResults.size());
    }

    public int getMinIterations() {
        return this.minIterations;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public List<TrainingResult> getTrainingResults() {
        return this.trainingResults;
    }

    public double getMeanIterations() {
        return this.meanIterations;
    }

    public double getStdIterations() {
        return this.stdIterations;
    }

    public String toString() {
        return "TrainingStatistics{minIterations=" + this.minIterations + ", maxIterations=" + this.maxIterations + ", meanIterations=" + this.meanIterations + ", stdIterations=" + this.stdIterations + ", minError=" + this.minError + ", maxError=" + this.maxError + ", meanError=" + this.meanError + ", stdError=" + this.stdError + '}';
    }

    public double getMinError() {
        return this.minError;
    }

    public double getMaxError() {
        return this.maxError;
    }

    public double getMeanError() {
        return this.meanError;
    }

    public double getStdError() {
        return this.stdError;
    }
}

