/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.bpbench;

import org.neuroph.contrib.bpbench.AbstractTraining;
import org.neuroph.contrib.bpbench.TrainingResult;
import org.neuroph.contrib.bpbench.TrainingSettings;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.learning.LearningRule;
import org.neuroph.nnet.learning.ResilientPropagation;

public class ResilientTraining
extends AbstractTraining {
    public ResilientTraining(NeuralNetwork neuralNet, DataSet dataset, TrainingSettings settings) {
        super(neuralNet, dataset, settings);
    }

    public ResilientTraining(DataSet dataset, TrainingSettings settings) {
        super(dataset, settings);
    }

    @Override
    public void testNeuralNet() {
        ResilientPropagation rp = (ResilientPropagation)this.setParameters();
        this.getNeuralNet().setLearningRule((LearningRule)rp);
        this.getNeuralNet().learn(this.getDataset());
        this.getStats().addData(new TrainingResult(rp.getCurrentIteration(), rp.getTotalNetworkError(), this.createMatrix()));
        this.getStats().calculateParameters();
    }

    @Override
    public LearningRule setParameters() {
        ResilientPropagation rp = new ResilientPropagation();
        rp.setBatchMode(this.getSettings().isBatchMode());
        rp.setMaxError(this.getSettings().getMaxError());
        rp.setMaxIterations(this.getSettings().getMaxIterations());
        rp.setDecreaseFactor(this.getSettings().getDecreaseFactor());
        rp.setIncreaseFactor(this.getSettings().getIncreaseFactor());
        rp.setInitialDelta(this.getSettings().getInitialDelta());
        rp.setMaxDelta(this.getSettings().getMaxDelta());
        rp.setMinDelta(this.getSettings().getMinDelta());
        return rp;
    }
}

