/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.bpbench;

import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.neuroph.contrib.bpbench.AbstractTraining;

public class ExportUtil {
    private static final String DELIMITER = ", ";

    public static void exportToCSV(String filePath, List<AbstractTraining> listOfTrainings) throws IOException {
        FileWriter out = new FileWriter(filePath + ".csv");
        out.write(ExportUtil.writeheader());
        for (AbstractTraining training : listOfTrainings) {
            out.write(ExportUtil.prepareLine(training));
        }
        out.flush();
        out.close();
    }

    private static String prepareLine(AbstractTraining training) {
        String line = "";
        line = line + training.getNeuralNet().getLearningRule().getClass().getName() + DELIMITER;
        line = line + training.getStats().getMinIterations() + DELIMITER;
        line = line + training.getStats().getMaxIterations() + DELIMITER;
        line = line + training.getStats().getMeanIterations() + DELIMITER;
        line = line + training.getStats().getStdIterations() + DELIMITER;
        line = line + training.getStats().getMinError() + DELIMITER;
        line = line + training.getStats().getMaxError() + DELIMITER;
        line = line + training.getStats().getMeanError() + DELIMITER;
        line = line + training.getStats().getStdError() + DELIMITER;
        line = line + training.getSettings().getLearningRate() + DELIMITER;
        line = line + training.getSettings().getMomentum() + DELIMITER;
        line = line + training.getSettings().getMaxIterations() + DELIMITER;
        line = line + training.getSettings().getMaxError() + DELIMITER;
        line = line + String.valueOf(training.getSettings().isBatchMode()) + DELIMITER;
        line = line + training.getSettings().getHiddenNeurons() + DELIMITER;
        line = line + training.getSettings().getDecreaseFactor() + DELIMITER;
        line = line + training.getSettings().getIncreaseFactor() + DELIMITER;
        line = line + training.getSettings().getInitialDelta() + DELIMITER;
        line = line + training.getSettings().getMaxDelta() + DELIMITER;
        line = line + training.getSettings().getMinDelta() + DELIMITER + "\n";
        return line;
    }

    private static String writeheader() {
        String header = "";
        header = header + "Algorithm, ";
        header = header + "Minimum iterations, ";
        header = header + "Maximum iterations, ";
        header = header + "Mean of iterations, ";
        header = header + "Standard deviation of iterations, ";
        header = header + "Minimum total error, ";
        header = header + "Maximum total error, ";
        header = header + "Mean of total error, ";
        header = header + "Standard deviation of total error, ";
        header = header + "Learning rate, ";
        header = header + "Momentum, ";
        header = header + "Maximum iterations, ";
        header = header + "Maximum error, ";
        header = header + "Batch mode, ";
        header = header + "Hidden neurons, ";
        header = header + "Decrease factor, ";
        header = header + "Increase factor, ";
        header = header + "Initial delta, ";
        header = header + "Maximum delta, ";
        header = header + "Minimum delta, \n";
        return header;
    }
}

