/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.bpbench;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.neuroph.contrib.bpbench.AbstractTraining;
import org.neuroph.contrib.bpbench.BackPropBenchmarks;
import org.neuroph.contrib.bpbench.BackpropagationTraining;
import org.neuroph.contrib.bpbench.MomentumTraining;
import org.neuroph.contrib.bpbench.TrainingSettings;
import org.neuroph.contrib.bpbench.TrainingSettingsGenerator;
import org.neuroph.core.data.DataSet;
import org.neuroph.nnet.MultiLayerPerceptron;
import org.neuroph.util.TransferFunctionType;

public class BackpropBenchmarksExample {
    public static void main(String[] args) throws IOException {
        BackPropBenchmarks bpb = new BackPropBenchmarks();
        bpb.setNoOfRepetitions(3);
        MultiLayerPerceptron mlp = new MultiLayerPerceptron(TransferFunctionType.SIGMOID, new int[]{4, 7, 3});
        DataSet trainingSet = DataSet.createFromFile((String)"iris_data_normalised.txt", (int)4, (int)3, (String)",");
        TrainingSettingsGenerator generator = new TrainingSettingsGenerator();
        Properties prop = new Properties();
        prop.setProperty("minLearningRate", "0.1");
        prop.setProperty("maxLearningRate", "0.4");
        prop.setProperty("learningRateStep", "0.5");
        prop.setProperty("minHiddenNeurons", "9");
        prop.setProperty("maxHiddenNeurons", "10");
        prop.setProperty("hiddenNeuronsStep", "1");
        prop.setProperty("momentum", "0.5");
        prop.setProperty("maxError", "0.1");
        prop.setProperty("maxIterations", "10000");
        prop.setProperty("batchMode", "true");
        generator.setSettings(prop);
        List<TrainingSettings> settingsCollection = generator.generateSettings();
        ArrayList<Class<? extends AbstractTraining>> trainingTypeCollection = new ArrayList<Class<? extends AbstractTraining>>();
        trainingTypeCollection.add(BackpropagationTraining.class);
        trainingTypeCollection.add(MomentumTraining.class);
        bpb.startBenchmark(trainingTypeCollection, settingsCollection, trainingSet, mlp);
        bpb.saveResults("C:\\Users\\Mladen\\Desktop\\test123");
    }
}

