/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.bpbench;

import org.neuroph.contrib.bpbench.TrainingSettings;
import org.neuroph.contrib.bpbench.TrainingStatistics;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.learning.LearningRule;
import org.neuroph.eval.ClassifierEvaluator;
import org.neuroph.eval.Evaluation;
import org.neuroph.eval.Evaluator;
import org.neuroph.eval.classification.ConfusionMatrix;
import org.neuroph.nnet.MultiLayerPerceptron;
import org.neuroph.util.TransferFunctionType;

public abstract class AbstractTraining {
    private final NeuralNetwork neuralNet;
    private final DataSet dataset;
    private TrainingStatistics stats;
    private TrainingSettings settings;

    public abstract void testNeuralNet();

    public abstract LearningRule setParameters();

    public ConfusionMatrix createMatrix() {
        Evaluation eval = new Evaluation();
        String[] classLabels = new String[this.dataset.getOutputSize()];
        for (int i = 0; i < this.dataset.getOutputSize(); ++i) {
            classLabels[i] = this.dataset.getColumnName(this.dataset.getInputSize() + i);
        }
        eval.addEvaluator((Evaluator)new ClassifierEvaluator.MultiClass(classLabels));
        return eval.evaluate(this.neuralNet, this.dataset).getConfusionMatrix();
    }

    public AbstractTraining(NeuralNetwork neuralNet, DataSet dataset, TrainingSettings settings) {
        this.neuralNet = neuralNet;
        this.dataset = dataset;
        this.stats = new TrainingStatistics();
        this.settings = settings;
    }

    public AbstractTraining(DataSet dataset, TrainingSettings settings) {
        this.dataset = dataset;
        this.settings = settings;
        this.stats = new TrainingStatistics();
        this.neuralNet = new MultiLayerPerceptron(TransferFunctionType.SIGMOID, new int[]{dataset.getInputSize(), settings.getHiddenNeurons(), dataset.getOutputSize()});
    }

    public TrainingSettings getSettings() {
        return this.settings;
    }

    public void setSettings(TrainingSettings settings) {
        this.settings = settings;
    }

    public DataSet getDataset() {
        return this.dataset;
    }

    public NeuralNetwork getNeuralNet() {
        return this.neuralNet;
    }

    public TrainingStatistics getStats() {
        return this.stats;
    }
}

