/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.art;

import java.util.List;
import org.neuroph.contrib.art.ART1CompetitiveNeuron;
import org.neuroph.contrib.art.ART1Network;
import org.neuroph.core.Connection;
import org.neuroph.core.Layer;
import org.neuroph.core.Neuron;
import org.neuroph.core.Weight;
import org.neuroph.util.NeuronProperties;

public class ARTF2Layer
extends Layer {
    private int maxIterations = 100;
    private ART1CompetitiveNeuron winner;

    public ARTF2Layer(int neuronNum, NeuronProperties neuronProperties) {
        super(neuronNum, neuronProperties);
    }

    public void calculate() {
        ART1CompetitiveNeuron artNeuron;
        double normOfF1b = 0.0;
        double normOfF1a = 0.0;
        int iterationsCount = 0;
        for (Neuron neuron : this.getNeurons()) {
            artNeuron = (ART1CompetitiveNeuron)neuron;
            if (artNeuron.isInhibited()) continue;
            neuron.calculate();
        }
        this.winner = null;
        do {
            for (Neuron neuron : this.getNeurons()) {
                artNeuron = (ART1CompetitiveNeuron)neuron;
                if (artNeuron.isInhibited()) continue;
                this.winner = artNeuron;
                break;
            }
            for (Neuron neuron : this.getNeurons()) {
                artNeuron = (ART1CompetitiveNeuron)neuron;
                if (!(artNeuron.getOutput() >= this.winner.getOutput())) continue;
                this.winner = artNeuron;
            }
            if (this.winner == null) continue;
            List winnerConnections = this.winner.getInputConnections();
            for (int i = 0; i < winnerConnections.size(); ++i) {
                Connection winnerConnection = (Connection)winnerConnections.get(i);
                Neuron f1bNeuron = winnerConnection.getFromNeuron();
                Neuron f1aNeuron = ((Connection)f1bNeuron.getInputConnections().get(i)).getFromNeuron();
                double f1bActivation = f1aNeuron.getOutput() * this.winner.getConnectionFrom((Neuron)f1bNeuron).getWeight().value;
                f1bNeuron.setOutput(f1bActivation);
            }
            for (Neuron neuron : this.getParentNetwork().getLayerAt(1).getNeurons()) {
                normOfF1b += neuron.getOutput();
            }
            for (Neuron neuron : this.getParentNetwork().getLayerAt(0).getNeurons()) {
                normOfF1a += neuron.getOutput();
            }
            ART1Network nnet = (ART1Network)this.getParentNetwork();
            if (normOfF1b / normOfF1a < nnet.getVigilance()) {
                this.winner.setInhibited(true);
                continue;
            }
            for (int i = 0; i < winnerConnections.size(); ++i) {
                Connection winnerConnection = (Connection)winnerConnections.get(i);
                Weight newWeight = new Weight();
                newWeight.setValue((double)nnet.getL() * winnerConnection.getFromNeuron().getOutput() / ((double)(nnet.getL() - 1) + normOfF1b));
                winnerConnection.setWeight(newWeight);
            }
            List topDownConnections = this.winner.getOutConnections();
            for (int i = 0; i < topDownConnections.size(); ++i) {
                Connection topDownConnection = (Connection)topDownConnections.get(i);
                Weight newWeight = new Weight();
                newWeight.setValue(topDownConnection.getToNeuron().getOutput());
            }
        } while (++iterationsCount <= 500);
        if (this.winner == null) {
            ART1CompetitiveNeuron newNeuron = new ART1CompetitiveNeuron();
            this.addNeuron(newNeuron);
            List f1BNeurons = this.getParentNetwork().getLayerAt(1).getNeurons();
            for (int i = 0; i < f1BNeurons.size(); ++i) {
                Neuron f1BNeuron = (Neuron)f1BNeurons.get(i);
                Connection bottomUp = new Connection(f1BNeuron, (Neuron)newNeuron);
                Weight weightB = new Weight();
                weightB.setValue(bottomUp.getFromNeuron().getOutput() / (0.5 + normOfF1b));
                bottomUp.setWeight(weightB);
                Connection topDown = new Connection((Neuron)newNeuron, f1BNeuron);
                Weight weightT = new Weight();
                weightT.setValue(f1BNeuron.getOutput());
                topDown.setWeight(weightT);
            }
        }
    }

    public ART1CompetitiveNeuron getWinner() {
        return this.winner;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }
}

