/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.contrib.art;

import java.util.ArrayList;
import java.util.List;
import org.neuroph.contrib.art.ART1Learning;
import org.neuroph.contrib.art.ARTF2Layer;
import org.neuroph.core.Connection;
import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.Neuron;
import org.neuroph.core.Weight;
import org.neuroph.core.input.InputFunction;
import org.neuroph.core.input.WeightedSum;
import org.neuroph.core.learning.LearningRule;
import org.neuroph.core.transfer.Linear;
import org.neuroph.core.transfer.Sigmoid;
import org.neuroph.core.transfer.TransferFunction;
import org.neuroph.nnet.comp.neuron.BiasNeuron;
import org.neuroph.nnet.comp.neuron.CompetitiveNeuron;
import org.neuroph.nnet.comp.neuron.InputNeuron;
import org.neuroph.util.ConnectionFactory;
import org.neuroph.util.LayerFactory;
import org.neuroph.util.NeuralNetworkFactory;
import org.neuroph.util.NeuronProperties;
import org.neuroph.util.TransferFunctionType;

public class ART1Network
extends NeuralNetwork<ART1Learning> {
    private double vigilance;
    private int L;

    public ART1Network(List<Integer> neuronsInLayers, double vigilance, int L) {
        NeuronProperties neuronProperties = new NeuronProperties();
        neuronProperties.setProperty("useBias", (Object)true);
        neuronProperties.setProperty("transferFunction", (Object)TransferFunctionType.SIGMOID);
        neuronProperties.setProperty("inputFunction", (Object)new WeightedSum());
        this.createNetwork(neuronsInLayers, neuronProperties, vigilance, L);
    }

    public ART1Network(double vigilance, int L, int ... neuronsInLayers) {
        NeuronProperties neuronProperties = new NeuronProperties();
        neuronProperties.setProperty("useBias", (Object)true);
        neuronProperties.setProperty("transferFunction", (Object)TransferFunctionType.SIGMOID);
        neuronProperties.setProperty("inputFunction", WeightedSum.class);
        ArrayList<Integer> neuronsInLayersVector = new ArrayList<Integer>();
        for (int i = 0; i < neuronsInLayers.length; ++i) {
            neuronsInLayersVector.add(new Integer(neuronsInLayers[i]));
        }
        this.createNetwork(neuronsInLayersVector, neuronProperties, vigilance, L);
    }

    public ART1Network(List<Integer> neuronsInLayers, NeuronProperties neuronProperties, double vigilance, int L) {
        this.createNetwork(neuronsInLayers, neuronProperties, vigilance, L);
    }

    private void createNetwork(List<Integer> neuronsInLayers, NeuronProperties neuronProperties, double vigilance, int L) {
        this.vigilance = vigilance;
        NeuronProperties inputNeuronProperties = new NeuronProperties(InputNeuron.class, Linear.class);
        Layer f1a = LayerFactory.createLayer((int)neuronsInLayers.get(0), (NeuronProperties)inputNeuronProperties);
        Layer f1b = LayerFactory.createLayer((int)neuronsInLayers.get(0), (NeuronProperties)inputNeuronProperties);
        ARTF2Layer f2 = new ARTF2Layer(neuronsInLayers.get(1), inputNeuronProperties);
        boolean useBias = true;
        if (neuronProperties.hasProperty("useBias")) {
            useBias = (Boolean)neuronProperties.getProperty("useBias");
        }
        if (useBias) {
            f1a.addNeuron((Neuron)new BiasNeuron());
            f1b.addNeuron((Neuron)new BiasNeuron());
            f2.addNeuron((Neuron)new CompetitiveNeuron((InputFunction)new WeightedSum(), (TransferFunction)new Sigmoid()));
        }
        this.addLayer(f1a);
        this.addLayer(f1b);
        this.addLayer(f2);
        ConnectionFactory.forwardConnect((Layer)f1a, (Layer)f1b);
        ConnectionFactory.fullConnect((Layer)f1b, (Layer)f2);
        ConnectionFactory.fullConnect((Layer)f2, (Layer)f1b);
        List f1bneurons = f1b.getNeurons();
        for (Neuron f1bneuron : f1bneurons) {
            List f1bneuronConnections = f1bneuron.getOutConnections();
            for (Connection f1bneuronConnection : f1bneuronConnections) {
                Weight w = new Weight((double)(L / (L - 1 + neuronsInLayers.get(0))));
                f1bneuronConnection.setWeight(w);
            }
        }
        List f2neurons = f2.getNeurons();
        for (Neuron f2neuron : f2neurons) {
            List f2neuronConnections = f2neuron.getOutConnections();
            for (Connection f2neuronConnection : f2neuronConnections) {
                Weight w = new Weight(1.0);
                f2neuronConnection.setWeight(w);
            }
        }
        NeuralNetworkFactory.setDefaultIO((NeuralNetwork)this);
        this.setLearningRule((LearningRule)new ART1Learning());
    }

    public void calculate() {
    }

    public double getVigilance() {
        return this.vigilance;
    }

    public void setVigilance(double vigilance) {
        this.vigilance = vigilance;
    }

    public int getL() {
        return this.L;
    }

    public void setL(int L) {
        this.L = L;
    }
}

