/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.number;

import com.github.mygreen.cellformatter.number.DecimalNumber;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class PercentNumber
extends DecimalNumber {
    public PercentNumber(double value, int decimalScale, int permilles) {
        super(value, decimalScale, permilles);
    }

    public PercentNumber(double value, int decimalScale) {
        this(value, decimalScale, 0);
    }

    @Override
    protected void init() {
        if (this.isZero()) {
            this.integerPart = "";
            this.decimalPart = "";
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("#");
        if (this.getScale() > 0) {
            sb.append(".");
        }
        for (int i = 0; i < this.getScale(); ++i) {
            sb.append("#");
        }
        sb.append("%");
        DecimalFormat format = new DecimalFormat(sb.toString());
        format.setRoundingMode(RoundingMode.HALF_UP);
        double num = Math.abs(this.getValue());
        if (this.getPermilles() > 0) {
            num /= Math.pow(1000.0, this.getPermilles());
        }
        String str = format.format(num);
        str = str.substring(0, str.length() - 1);
        this.setupIntegerAndDecimalPart(str);
    }

    @Override
    public String toString() {
        return super.toString() + "%";
    }
}

