/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.lang;

import com.github.mygreen.cellformatter.lang.MSLocale;
import com.github.mygreen.cellformatter.lang.MessageResource;
import com.github.mygreen.cellformatter.lang.Utils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class MessageResolver {
    private final String resourceName;
    private final boolean allowedNoDefault;
    private final boolean appendUserResource;
    private MessageResource defaultResource;
    private Map<Locale, MessageResource> resources;

    public MessageResolver(String resourceName) {
        this(resourceName, false, false);
    }

    public MessageResolver(String resourceName, boolean allowedNoDefault, boolean appendUserResouce) {
        this.resourceName = resourceName;
        this.allowedNoDefault = allowedNoDefault;
        this.appendUserResource = appendUserResouce;
        this.defaultResource = this.loadDefaultResource(allowedNoDefault, appendUserResouce);
        this.resources = new ConcurrentHashMap<Locale, MessageResource>();
    }

    private String getPropertyPath() {
        String baseName = this.getResourceName().replaceAll("\\.", "/");
        String path = "/" + baseName + ".properties";
        return path;
    }

    private String[] getPropertyPath(Locale locale) {
        String path;
        ArrayList<String> list = new ArrayList<String>();
        String baseName = this.getResourceName().replaceAll("\\.", "/");
        if (Utils.isNotEmpty(locale.getLanguage())) {
            path = "/" + baseName + "_" + locale.getLanguage() + ".properties";
            list.add(path);
        }
        if (Utils.isNotEmpty(locale.getLanguage()) && Utils.isNotEmpty(locale.getCountry())) {
            path = "/" + baseName + "_" + locale.getLanguage() + "_" + locale.getCountry() + ".properties";
            list.add(path);
        }
        Collections.reverse(list);
        return list.toArray(new String[list.size()]);
    }

    private MessageResource loadDefaultResource(boolean allowedNoDefault, boolean appendUserResource) {
        String path = this.getPropertyPath();
        Properties props = new Properties();
        try {
            props.load(new InputStreamReader(MessageResolver.class.getResourceAsStream(path), "UTF-8"));
        }
        catch (IOException | NullPointerException e) {
            if (allowedNoDefault) {
                return MessageResource.NULL_OBJECT;
            }
            throw new RuntimeException("fail default properties. :" + path, e);
        }
        MessageResource resource = new MessageResource();
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = props.getProperty(key);
            resource.addMessage(key, value);
        }
        if (appendUserResource) {
            resource.addMessage(this.loadUserResource(path));
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageResource loadResource(Locale locale) {
        if (locale == null) {
            return this.defaultResource;
        }
        if (this.resources.containsKey(locale)) {
            return this.resources.get(locale);
        }
        MessageResource localeResource = null;
        Map<Locale, MessageResource> map = this.resources;
        synchronized (map) {
            for (String path : this.getPropertyPath(locale)) {
                try {
                    Properties props = new Properties();
                    props.load(new InputStreamReader(MessageResolver.class.getResourceAsStream(path), "UTF-8"));
                    localeResource = new MessageResource();
                    Enumeration<?> keys = props.propertyNames();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        String value = props.getProperty(key);
                        localeResource.addMessage(key, value);
                    }
                    if (!this.appendUserResource) break;
                    localeResource.addMessage(this.loadUserResource(path));
                    break;
                }
                catch (IOException | NullPointerException e) {
                }
            }
            if (localeResource == null) {
                localeResource = this.defaultResource;
            }
            this.resources.put(locale, localeResource);
        }
        return localeResource;
    }

    private MessageResource loadUserResource(String basePath) {
        int index = basePath.lastIndexOf("/");
        if (index <= 0) {
            return MessageResource.NULL_OBJECT;
        }
        String userPropertyPath = "/" + basePath.substring(index + 1);
        try {
            Properties props = new Properties();
            props.load(new InputStreamReader(MessageResolver.class.getResourceAsStream(userPropertyPath), "UTF-8"));
            MessageResource resource = new MessageResource();
            Enumeration<?> keys = props.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = props.getProperty(key);
                resource.addMessage(key, value);
            }
            return resource;
        }
        catch (IOException | NullPointerException e) {
            return MessageResource.NULL_OBJECT;
        }
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public boolean isAllowedNoDefault() {
        return this.allowedNoDefault;
    }

    public String getMessage(String key) {
        return this.defaultResource.getMessage(key);
    }

    public String getMessage(MSLocale locale, String key) {
        if (locale == null) {
            return this.loadResource(null).getMessage(key);
        }
        return this.loadResource(locale.getLocale()).getMessage(key);
    }

    public String getMessage(MSLocale locale, String key, String defaultValue) {
        String message = this.getMessage(locale, key);
        return message == null ? defaultValue : message;
    }

    public String getMessage(Locale locale, String key) {
        return this.loadResource(locale).getMessage(key);
    }

    public String getMessage(Locale locale, String key, String defaultValue) {
        String message = this.getMessage(locale, key);
        return message == null ? defaultValue : message;
    }

    public String getMessage(MSLocale formatLocale, Locale runtimeLocale, String key) {
        if (formatLocale != null) {
            return this.getMessage(formatLocale, key);
        }
        return this.getMessage(runtimeLocale, key);
    }

    public String getMessage(MSLocale formatLocale, Locale runtimeLocale, String key, String defaultValue) {
        if (formatLocale != null) {
            return this.getMessage(formatLocale, key, defaultValue);
        }
        return this.getMessage(runtimeLocale, key, defaultValue);
    }
}

