/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.lang;

import com.github.mygreen.cellformatter.lang.ArgUtils;
import java.lang.reflect.Field;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.SheetImpl;
import jxl.read.biff.WorkbookParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JXLUtils {
    private static final Logger logger = LoggerFactory.getLogger(JXLUtils.class);

    public static boolean isDateStart1904(Workbook workbook) {
        ArgUtils.notNull(workbook, "workbook");
        if (workbook instanceof WorkbookParser) {
            try {
                Field field = WorkbookParser.class.getDeclaredField("nineteenFour");
                field.setAccessible(true);
                boolean value = field.getBoolean(workbook);
                return value;
            }
            catch (NoSuchFieldException | SecurityException e) {
                logger.warn("fail access field WrokbookParser#nineteenFour", (Throwable)e);
                return false;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                logger.warn("fail invoke field WrokbookParser#nineteenFour", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public static boolean isDateStart1904(Sheet sheet) {
        ArgUtils.notNull(sheet, "sheet");
        if (sheet instanceof SheetImpl) {
            try {
                Field field = SheetImpl.class.getDeclaredField("nineteenFour");
                field.setAccessible(true);
                boolean value = field.getBoolean(sheet);
                return value;
            }
            catch (NoSuchFieldException | SecurityException e) {
                logger.warn("fail access field SheetImpl#nineteenFour", (Throwable)e);
                return false;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                logger.warn("fail invoke field SheetImpl#nineteenFour", (Throwable)e);
                return false;
            }
        }
        return false;
    }
}

