/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.lang;

import com.github.mygreen.cellformatter.lang.ArgUtils;
import com.github.mygreen.cellformatter.lang.EraPeriod;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class Era {
    public static final Era UNKNOWN_ERA = new Era(Collections.emptyList()){

        @Override
        public boolean isUnkndown() {
            return true;
        }
    };
    private final List<EraPeriod> periods;

    public Era(List<EraPeriod> periods) {
        ArgUtils.notNull(periods, "periods");
        this.periods = Collections.unmodifiableList(periods);
    }

    public boolean contains(Date date) {
        ArgUtils.notNull(date, "date");
        for (EraPeriod period : this.periods) {
            if (!period.contains(date)) continue;
            return true;
        }
        return false;
    }

    public EraPeriod getTargetPeriod(Date date) {
        ArgUtils.notNull(date, "date");
        for (EraPeriod period : this.periods) {
            if (!period.contains(date)) continue;
            return period;
        }
        return EraPeriod.UNKNOWN_PERIOD;
    }

    public boolean isUnkndown() {
        return false;
    }
}

