/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.callback;

import com.github.mygreen.cellformatter.lang.ArgUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KansujiConverter {
    protected static final Pattern PATTERN_NUM = Pattern.compile("([\\D]*)([\\d]+)([\\.]{0,1}[.\\s\\w]*)");
    protected String[] numMap = new String[]{"\u3007", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    protected String[] digits10Map = new String[]{"", "\u4e07", "\u5104", "\u5146", "\u4eac"};
    protected String[] digits4Map = new String[]{"", "\u5341", "\u767e", "\u5343"};

    public String convert(String value, boolean is4YearTerm) {
        Matcher matcher = PATTERN_NUM.matcher(value);
        if (!matcher.matches()) {
            return this.replaceSimple(value);
        }
        String before = matcher.group(1);
        String num = matcher.group(2);
        String after = matcher.group(3);
        if (is4YearTerm && num.length() == 4) {
            return this.replaceSimple(before) + this.replaceSimple(num) + this.replaceSimple(after);
        }
        return this.replaceSimple(before) + this.replaceDisits(num) + this.replaceSimple(after);
    }

    protected String replaceSimple(String value) {
        String str = value;
        for (int i = 0; i < this.numMap.length; ++i) {
            str = str.replaceAll(String.valueOf(i), this.numMap[i]);
        }
        return str;
    }

    protected String replaceDisits(String value) {
        if (value.equals("0")) {
            return this.numMap[0];
        }
        int length = value.length();
        ArrayList<String> split4 = new ArrayList<String>();
        for (int i = 0; i < length; i += 4) {
            int end = length - i;
            int start = i + 4 < length ? end - 4 : 0;
            String item = value.substring(start, end);
            split4.add(item);
        }
        ArrayList<String> digits = new ArrayList<String>();
        for (int i = 0; i < split4.size(); ++i) {
            String item = (String)split4.get(i);
            item = this.replace4Digits(item) + this.digits10Map[i];
            digits.add(item);
        }
        Collections.reverse(digits);
        StringBuilder sb = new StringBuilder();
        for (String item : digits) {
            sb.append(item);
        }
        return sb.toString();
    }

    protected String replace4Digits(String value) {
        int length = value.length();
        ArrayList<String> digits = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(length - i - 1);
            if (c == '0') continue;
            String item = c == '1' && i > 0 ? this.digits4Map[i] : this.replaceSimple(String.valueOf(c)) + this.digits4Map[i];
            digits.add(item);
        }
        Collections.reverse(digits);
        StringBuilder sb = new StringBuilder();
        for (String item : digits) {
            sb.append(item);
        }
        return sb.toString();
    }

    public void setNumMap(String[] numMap) {
        ArgUtils.notEmpty(numMap, "numMap");
        if (numMap.length != 10) {
            throw new IllegalArgumentException("numMap length should be 10.");
        }
        this.numMap = numMap;
    }

    public void setDigits10Map(String[] digits10Map) {
        ArgUtils.notEmpty(digits10Map, "digits10Map");
        if (digits10Map.length != 5) {
            throw new IllegalArgumentException("digits10Map length should be 5.");
        }
        this.digits10Map = digits10Map;
    }

    public void setDigits4Map(String[] digits4Map) {
        ArgUtils.notEmpty(digits4Map, "digits4Map");
        if (digits4Map.length != 4) {
            throw new IllegalArgumentException("digits4Map length should be 4.");
        }
        this.digits4Map = digits4Map;
    }
}

