/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

import com.github.mygreen.cellformatter.CommonCell;
import com.github.mygreen.cellformatter.lang.ArgUtils;
import java.util.Date;

public abstract class ObjectCell<T>
implements CommonCell {
    protected final T value;
    private final short formatIndex;
    protected final String formatPattern;

    public ObjectCell(T value, short formatIndex) {
        ArgUtils.notNull(value, "value");
        ArgUtils.notMin(formatIndex, (short)0, "formatIndex");
        this.value = value;
        this.formatIndex = formatIndex;
        this.formatPattern = null;
    }

    public ObjectCell(T value, String formatPattern) {
        ArgUtils.notNull(value, "value");
        ArgUtils.notEmpty(formatPattern, "formatPattern");
        this.value = value;
        this.formatIndex = (short)-1;
        this.formatPattern = formatPattern;
    }

    public ObjectCell(T value, short formatIndex, String formatPattern) {
        ArgUtils.notNull(value, "value");
        ArgUtils.notMin(formatIndex, (short)0, "formatIndex");
        ArgUtils.notEmpty(formatPattern, "formatPattern");
        this.value = value;
        this.formatIndex = formatIndex;
        this.formatPattern = formatPattern;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public short getFormatIndex() {
        return this.formatIndex;
    }

    @Override
    public String getFormatPattern() {
        return this.formatPattern;
    }

    @Override
    public boolean isText() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public String getTextCellValue() {
        throw new IllegalStateException("not match value type.");
    }

    @Override
    public boolean getBooleanCellValue() {
        throw new IllegalStateException("not match value type.");
    }

    @Override
    public double getNumberCellValue() {
        throw new IllegalStateException("not match value type.");
    }

    @Override
    public Date getDateCellValue() {
        throw new IllegalStateException("not match value type.");
    }

    @Override
    public boolean isDateStart1904() {
        return false;
    }

    @Override
    public String getCellAddress() {
        return "A1";
    }
}

