/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

import com.github.mygreen.cellformatter.CellFormatResult;
import com.github.mygreen.cellformatter.CommonCell;
import com.github.mygreen.cellformatter.ConditionOperator;
import com.github.mygreen.cellformatter.FormatterType;
import com.github.mygreen.cellformatter.callback.Callback;
import com.github.mygreen.cellformatter.lang.MSColor;
import com.github.mygreen.cellformatter.lang.MSLocale;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class ConditionFormatter {
    protected final String pattern;
    protected ConditionOperator operator;
    protected MSLocale locale;
    protected MSColor color;
    protected List<String> conditions = new CopyOnWriteArrayList<String>();
    protected List<Callback<?>> callbacks = new CopyOnWriteArrayList();

    public ConditionFormatter(String pattern) {
        this.pattern = pattern;
    }

    public abstract FormatterType getType();

    public abstract boolean isMatch(CommonCell var1);

    public CellFormatResult format(CommonCell cell) {
        return this.format(cell, Locale.getDefault());
    }

    public abstract CellFormatResult format(CommonCell var1, Locale var2);

    public boolean isDateFormatter() {
        return this.getType() == FormatterType.Date;
    }

    public boolean isNumberFormatter() {
        return this.getType() == FormatterType.Number;
    }

    public boolean isTextFormatter() {
        return this.getType() == FormatterType.Text;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void addCondition(String condition) {
        this.conditions.add(condition);
    }

    public void addAllCondition(List<String> conditions) {
        this.conditions.addAll(conditions);
    }

    public List<String> getConditions() {
        return this.conditions;
    }

    public MSColor getColor() {
        return this.color;
    }

    public void setColor(MSColor color) {
        this.color = color;
    }

    public ConditionOperator getOperator() {
        return this.operator;
    }

    public void setOperator(ConditionOperator operator) {
        this.operator = operator;
    }

    public MSLocale getLocale() {
        return this.locale;
    }

    public void setLocale(MSLocale locale) {
        this.locale = locale;
    }

    public void addCallback(Callback<?> callback) {
        this.callbacks.add(callback);
    }

    public void addFirstCallcack(Callback<?> callback) {
        ArrayList list = new ArrayList();
        list.add(callback);
        list.addAll(this.callbacks);
        this.callbacks.clear();
        this.callbacks.addAll(list);
    }

    public List<Callback<?>> getCallbacks() {
        return this.callbacks;
    }
}

