/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

import com.github.mygreen.cellformatter.CellFormatResult;
import com.github.mygreen.cellformatter.CommonCell;
import com.github.mygreen.cellformatter.ConditionFormatter;
import com.github.mygreen.cellformatter.FormatCellType;
import com.github.mygreen.cellformatter.FormatterType;
import com.github.mygreen.cellformatter.callback.Callback;
import com.github.mygreen.cellformatter.lang.ArgUtils;
import com.github.mygreen.cellformatter.lang.ExcelDateUtils;
import com.github.mygreen.cellformatter.term.DateTerm;
import com.github.mygreen.cellformatter.term.Term;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionDateFormatter
extends ConditionFormatter {
    private static final Logger logger = LoggerFactory.getLogger(ConditionDateFormatter.class);
    private List<Term<Calendar>> terms = new CopyOnWriteArrayList<Term<Calendar>>();

    public ConditionDateFormatter(String pattern) {
        super(pattern);
    }

    @Override
    public FormatterType getType() {
        return FormatterType.Date;
    }

    @Override
    public boolean isMatch(CommonCell cell) {
        if (!cell.isNumber()) {
            return false;
        }
        long zeroTime = ExcelDateUtils.getExcelZeroDateTime(cell.isDateStart1904());
        Date date = cell.getDateCellValue();
        long value = date.getTime() - zeroTime;
        if (logger.isDebugEnabled()) {
            logger.debug("isMatch::date={}, zeroTime={}, diff={}", new Object[]{ExcelDateUtils.formatDate(date), ExcelDateUtils.formatDate(new Date(zeroTime)), value});
        }
        return this.getOperator().isMatch(value);
    }

    @Override
    public CellFormatResult format(CommonCell cell, Locale runtimeLocale) {
        ArgUtils.notNull(cell, "date");
        Date date = cell.getDateCellValue();
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT-00:00"));
        cal.setTime(date);
        StringBuilder sb = new StringBuilder();
        for (Term<Calendar> term : this.terms) {
            String formatValue = term instanceof DateTerm ? ((DateTerm)term).format(cal, this.getLocale(), runtimeLocale, cell.isDateStart1904()) : term.format(cal, this.getLocale(), runtimeLocale);
            sb.append(this.applyFormatCallback(cal, formatValue, runtimeLocale, term));
        }
        String value = sb.toString();
        CellFormatResult result = new CellFormatResult();
        result.setValue(date);
        result.setText(value);
        result.setTextColor(this.getColor());
        result.setSectionPattern(this.getPattern());
        result.setCellType(FormatCellType.Date);
        return result;
    }

    private String applyFormatCallback(Calendar cal, String str, Locale runtimeLocale, Term<Calendar> term) {
        String value = str;
        for (Callback<Calendar> callback : this.getCallbacks()) {
            Locale locale;
            if (!callback.isApplicable(locale = this.getLocale() != null ? this.getLocale().getLocale() : runtimeLocale)) continue;
            value = callback.call(cal, value, locale, term);
        }
        return value;
    }

    public void addTerm(Term<Calendar> term) {
        this.terms.add(term);
    }

    public void addAllTerms(List<Term<Calendar>> terms) {
        this.terms.addAll(terms);
    }

    public List<Term<Calendar>> getTerms() {
        return this.terms;
    }
}

