/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.jetty.jupiter;

import com.github.mjeanroy.junit.servers.engine.Servers;
import com.github.mjeanroy.junit.servers.jetty.EmbeddedJetty;
import com.github.mjeanroy.junit.servers.jetty.EmbeddedJettyConfiguration;
import com.github.mjeanroy.junit.servers.jetty.exceptions.IllegalJettyConfigurationException;
import com.github.mjeanroy.junit.servers.jupiter.JunitServerExtension;
import com.github.mjeanroy.junit.servers.servers.AbstractConfiguration;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;

public class JettyServerExtension
extends JunitServerExtension {
    public JettyServerExtension() {
    }

    public JettyServerExtension(EmbeddedJetty jetty) {
        super((EmbeddedServer)jetty);
    }

    public JettyServerExtension(EmbeddedJettyConfiguration configuration) {
        super((AbstractConfiguration)configuration);
    }

    protected EmbeddedServer<?> instantiateServer(Class<?> testClass, AbstractConfiguration configuration) {
        EmbeddedJettyConfiguration configurationToUse = JettyServerExtension.extractConfiguration(testClass, configuration);
        return configurationToUse == null ? new EmbeddedJetty() : new EmbeddedJetty(configurationToUse);
    }

    private static EmbeddedJettyConfiguration extractConfiguration(Class<?> testClass, AbstractConfiguration configuration) {
        AbstractConfiguration configurationToUse;
        AbstractConfiguration abstractConfiguration = configurationToUse = configuration == null ? Servers.findConfiguration(testClass) : configuration;
        if (configurationToUse == null) {
            return null;
        }
        if (!(configurationToUse instanceof EmbeddedJettyConfiguration)) {
            throw new IllegalJettyConfigurationException();
        }
        return (EmbeddedJettyConfiguration)configurationToUse;
    }
}

