/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.servers;

import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import com.github.mjeanroy.junit.servers.servers.Hook;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractConfiguration {
    static final String DEFAULT_PATH = "/";
    static final String DEFAULT_WEBAPP = "src/main/webapp";
    static final String DEFAULT_CLASSPATH = ".";
    static final int DEFAULT_PORT = 0;
    private final String path;
    private final String webapp;
    private final int port;
    private final String classpath;
    private final ClassLoader parentClassLoader;
    private final Map<String, String> envProperties;
    private final List<Hook> hooks;
    private final String overrideDescriptor;

    protected AbstractConfiguration() {
        this.classpath = DEFAULT_CLASSPATH;
        this.path = DEFAULT_PATH;
        this.webapp = DEFAULT_WEBAPP;
        this.port = 0;
        this.envProperties = Collections.emptyMap();
        this.hooks = Collections.emptyList();
        this.parentClassLoader = null;
        this.overrideDescriptor = null;
    }

    protected AbstractConfiguration(String classpath, String path, String webapp, int port, Map<String, String> envProperties, List<Hook> hooks, ClassLoader parentClassLoader, String overrideDescriptor) {
        this.classpath = Preconditions.notNull(classpath, "classpath");
        this.path = Preconditions.notNull(path, "path");
        this.webapp = Preconditions.notNull(webapp, "webapp");
        this.port = Preconditions.positive(port, "port");
        this.envProperties = new LinkedHashMap<String, String>(envProperties);
        this.hooks = new ArrayList<Hook>(hooks);
        this.parentClassLoader = parentClassLoader;
        this.overrideDescriptor = overrideDescriptor;
    }

    public String getPath() {
        return this.path;
    }

    public String getWebapp() {
        return this.webapp;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public int getPort() {
        return this.port;
    }

    public String getOverrideDescriptor() {
        return this.overrideDescriptor;
    }

    public Map<String, String> getEnvProperties() {
        return Collections.unmodifiableMap(this.envProperties);
    }

    public List<Hook> getHooks() {
        return Collections.unmodifiableList(this.hooks);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AbstractConfiguration) {
            AbstractConfiguration c = (AbstractConfiguration)o;
            return c.canEqual(this) && Objects.equals(this.port, c.port) && Objects.equals(this.path, c.path) && Objects.equals(this.webapp, c.webapp) && Objects.equals(this.classpath, c.classpath) && Objects.equals(this.envProperties, c.envProperties) && Objects.equals(this.hooks, c.hooks) && Objects.equals(this.overrideDescriptor, c.overrideDescriptor) && Objects.equals(this.parentClassLoader, c.parentClassLoader);
        }
        return false;
    }

    protected boolean canEqual(Object o) {
        return this.getClass().isInstance(o);
    }

    public int hashCode() {
        return Objects.hash(this.port, this.path, this.webapp, this.classpath, this.envProperties, this.hooks, this.overrideDescriptor, this.parentClassLoader);
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("port", this.port).append("path", this.path).append("webapp", this.webapp).append("classpath", this.classpath).append("overrideDescriptor", this.overrideDescriptor).append("parentClassLoader", this.parentClassLoader).build();
    }
}

