/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.jupiter;

import com.github.mjeanroy.junit.servers.annotations.TestHttpClient;
import com.github.mjeanroy.junit.servers.client.HttpClientConfiguration;
import com.github.mjeanroy.junit.servers.client.HttpClientConfigurationFactory;
import com.github.mjeanroy.junit.servers.client.HttpClientStrategy;
import com.github.mjeanroy.junit.servers.commons.reflect.Classes;
import com.github.mjeanroy.junit.servers.engine.EmbeddedServerRunner;
import com.github.mjeanroy.junit.servers.jupiter.ParameterResolverFunction;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import java.util.Optional;
import org.junit.jupiter.api.extension.ParameterContext;

class HttpClientParameterResolverFunction
implements ParameterResolverFunction {
    private static final Logger log = LoggerFactory.getLogger(HttpClientParameterResolverFunction.class);
    private static final HttpClientParameterResolverFunction INSTANCE = new HttpClientParameterResolverFunction();

    static HttpClientParameterResolverFunction getInstance() {
        return INSTANCE;
    }

    private HttpClientParameterResolverFunction() {
    }

    @Override
    public Object resolve(ParameterContext parameterContext, EmbeddedServerRunner serverAdapter) {
        HttpClientConfiguration configuration;
        HttpClientStrategy strategy;
        log.debug("Resolving HTTP Client for parameter: {}", parameterContext);
        Optional maybeAnnotation = parameterContext.findAnnotation(TestHttpClient.class);
        if (maybeAnnotation.isPresent()) {
            TestHttpClient annotation = (TestHttpClient)maybeAnnotation.get();
            strategy = HttpClientParameterResolverFunction.getStrategy(annotation);
            configuration = HttpClientParameterResolverFunction.getConfiguration(annotation);
        } else {
            strategy = HttpClientParameterResolverFunction.defaultStrategy();
            configuration = HttpClientConfiguration.defaultConfiguration();
        }
        return serverAdapter.getClient(strategy, configuration);
    }

    private static HttpClientStrategy getStrategy(TestHttpClient client) {
        return client.strategy();
    }

    private static HttpClientConfiguration getConfiguration(TestHttpClient client) {
        Class<? extends HttpClientConfigurationFactory> factoryClass = client.configuration();
        HttpClientConfigurationFactory factory = Classes.instantiate(factoryClass);
        return factory.build();
    }

    private static HttpClientStrategy defaultStrategy() {
        return HttpClientStrategy.AUTO;
    }
}

