/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.engine;

import com.github.mjeanroy.junit.servers.annotations.TestServerConfiguration;
import com.github.mjeanroy.junit.servers.commons.reflect.Reflections;
import com.github.mjeanroy.junit.servers.exceptions.DuplicateConfigurationException;
import com.github.mjeanroy.junit.servers.exceptions.ServerImplMissingException;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import com.github.mjeanroy.junit.servers.servers.AbstractConfiguration;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServerProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public final class Servers {
    private static final Logger log = LoggerFactory.getLogger(Servers.class);

    private Servers() {
    }

    public static EmbeddedServer<?> instantiate(Class<?> klass) {
        Object configuration = Servers.findConfiguration(klass);
        return Servers.instantiate(configuration);
    }

    public static <CONFIGURATION extends AbstractConfiguration> EmbeddedServer<CONFIGURATION> instantiate(CONFIGURATION configuration) {
        log.debug("Instantiating embedded server using configuration: {}", configuration);
        ServiceLoader<EmbeddedServerProvider> serviceProviders = ServiceLoader.load(EmbeddedServerProvider.class);
        ArrayList<EmbeddedServerProvider> coreServerProviders = new ArrayList<EmbeddedServerProvider>();
        ArrayList<EmbeddedServerProvider> customServerProviders = new ArrayList<EmbeddedServerProvider>();
        for (EmbeddedServerProvider provider : serviceProviders) {
            Class<?> providerClass = provider.getClass();
            log.debug("Found provider {}", providerClass);
            if (providerClass.getName().startsWith("com.github.mjeanroy.junit.servers")) {
                coreServerProviders.add(provider);
                continue;
            }
            customServerProviders.add(provider);
        }
        if (coreServerProviders.isEmpty() && customServerProviders.isEmpty()) {
            log.error("Cannot find embedded server implementation, please add `junit-servers-tomcat` or `junit-server-jetty` dependency or provide your own service loader.");
            throw new ServerImplMissingException();
        }
        if (customServerProviders.isEmpty()) {
            return Servers.instantiate((EmbeddedServerProvider)coreServerProviders.get(0), configuration);
        }
        if (customServerProviders.size() > 1) {
            throw new ServerImplMissingException();
        }
        return Servers.instantiate((EmbeddedServerProvider)customServerProviders.get(0), configuration);
    }

    private static <CONFIGURATION extends AbstractConfiguration> EmbeddedServer<CONFIGURATION> instantiate(EmbeddedServerProvider<CONFIGURATION> provider, CONFIGURATION configuration) {
        log.debug("Instantiate embedded server using provider: {}", provider);
        return configuration == null ? provider.instantiate() : provider.instantiate(configuration);
    }

    public static <CONFIGURATION extends AbstractConfiguration> CONFIGURATION findConfiguration(Class<?> klass) {
        log.debug("Extract configuration from class: {}", klass);
        List<Method> methods = Reflections.findStaticMethodsAnnotatedWith(klass, TestServerConfiguration.class);
        List<Field> fields = Reflections.findStaticFieldsAnnotatedWith(klass, TestServerConfiguration.class);
        int nbOfConfigurations = methods.size() + fields.size();
        if (nbOfConfigurations > 1) {
            log.error("Found {} eligible configuration, fail", nbOfConfigurations);
            Servers.failBecauseOfDuplicateConfiguration(klass, methods, fields);
        }
        if (!methods.isEmpty()) {
            log.debug("Extracting configuration from method {}", methods.get(0));
            return (CONFIGURATION)((AbstractConfiguration)Reflections.invoke(methods.get(0)));
        }
        if (!fields.isEmpty()) {
            log.debug("Extracting configuration from field {}", fields.get(0));
            return (CONFIGURATION)((AbstractConfiguration)Reflections.getter(fields.get(0)));
        }
        return null;
    }

    private static void failBecauseOfDuplicateConfiguration(Class<?> klass, List<Method> methods, List<Field> fields) {
        ArrayList<String> lines = new ArrayList<String>(1 + methods.size() + fields.size());
        lines.add("It looks like multiple fields may be used to extract configuration: found:");
        for (Method method : methods) {
            lines.add("- " + klass.getName() + "#" + method.getName() + "()");
        }
        for (Field field : fields) {
            lines.add("- " + klass.getName() + "#" + field.getName());
        }
        throw new DuplicateConfigurationException(String.join((CharSequence)System.lineSeparator(), lines));
    }
}

