/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.commons.lang;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.TimeZone;

public final class Dates {
    private Dates() {
    }

    static Date parse(String date, String pattern, String ... patterns) {
        HashSet<String> set = new HashSet<String>();
        set.add(pattern);
        if (patterns != null) {
            Collections.addAll(set, patterns);
        }
        for (String p : set) {
            try {
                return Dates.df(p).parse(date);
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    public static Long getTime(String date, String pattern, String ... patterns) {
        Date d = Dates.parse(date, pattern, patterns);
        return d == null ? null : Long.valueOf(d.getTime());
    }

    public static String format(Date date, String pattern) {
        return Dates.df(pattern).format(date);
    }

    static String formatTime(long time, String pattern) {
        Date date = new Date();
        date.setTime(time);
        return Dates.format(date, pattern);
    }

    private static DateFormat df(String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern, Locale.ENGLISH);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df;
    }
}

