/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.commons.core;

import com.github.mjeanroy.junit.servers.exceptions.UrlException;
import java.net.URI;
import java.net.URISyntaxException;

public final class Urls {
    private static final String[] HTTP_SCHEMES = new String[]{"http://", "https://"};
    private static final char PATH_SEPARATOR = '/';

    private Urls() {
    }

    static URI createUri(String scheme, String host, int port, String path) {
        try {
            return new URI(scheme, null, host, port, path, null, null);
        }
        catch (URISyntaxException ex) {
            throw new UrlException(scheme, host, port, path, ex);
        }
    }

    public static String ensureAbsolutePath(String path) {
        if (path == null || path.isEmpty()) {
            return String.valueOf('/');
        }
        return path.charAt(0) == '/' ? path : '/' + path;
    }

    public static String concatenatePath(String path, String endpoint) {
        String firstSegment = Urls.ensureAbsolutePath(path);
        if (endpoint == null || endpoint.isEmpty()) {
            return firstSegment;
        }
        StringBuilder sb = new StringBuilder(firstSegment);
        if (path.charAt(path.length() - 1) != '/') {
            sb.append('/');
        }
        if (endpoint.charAt(0) == '/') {
            sb.append(endpoint.substring(1));
        } else {
            sb.append(endpoint);
        }
        return sb.toString();
    }

    public static boolean startsWithHttpScheme(String url) {
        if (url == null || url.isEmpty()) {
            return false;
        }
        for (String scheme : HTTP_SCHEMES) {
            String prefix;
            int prefixLength = scheme.length();
            if (url.length() <= prefixLength || !(prefix = url.substring(0, prefixLength)).equalsIgnoreCase(scheme)) continue;
            return true;
        }
        return false;
    }
}

