/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client.impl.ning;

import com.github.mjeanroy.junit.servers.client.Cookies;
import com.github.mjeanroy.junit.servers.client.HttpHeader;
import com.github.mjeanroy.junit.servers.client.HttpMethod;
import com.github.mjeanroy.junit.servers.client.HttpParameter;
import com.github.mjeanroy.junit.servers.client.HttpResponse;
import com.github.mjeanroy.junit.servers.client.HttpUrl;
import com.github.mjeanroy.junit.servers.client.impl.AbstractHttpRequest;
import com.github.mjeanroy.junit.servers.client.impl.ning.NingAsyncHttpResponseFactory;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.uri.Uri;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.IOException;

class NingAsyncHttpRequest
extends AbstractHttpRequest {
    private static final Logger log = LoggerFactory.getLogger(NingAsyncHttpRequest.class);
    private final AsyncHttpClient client;

    NingAsyncHttpRequest(AsyncHttpClient client, HttpMethod httpMethod, HttpUrl url) {
        super(url, httpMethod);
        this.client = client;
    }

    @Override
    protected HttpResponse doExecute() throws Exception {
        HttpUrl endpoint = this.getEndpoint();
        String scheme = endpoint.getScheme();
        String userInfo = null;
        String host = endpoint.getHost();
        int port = endpoint.getPort();
        String path = UTF8UrlEncoder.encodePath((String)endpoint.getPath());
        String query = null;
        Uri uri = new Uri(scheme, userInfo, host, port, path, query);
        String method = this.getMethod().getVerb();
        RequestBuilder builder = (RequestBuilder)new RequestBuilder(method, true).setUri(uri);
        this.handleQueryParameters(builder);
        this.handleBody(builder);
        this.handleHeaders(builder);
        this.handleCookies(builder);
        Request request = builder.build();
        long start = System.nanoTime();
        Response response = (Response)this.client.executeRequest(request).get();
        long duration = System.nanoTime() - start;
        return NingAsyncHttpResponseFactory.of(response, duration);
    }

    private void handleQueryParameters(RequestBuilder builder) {
        for (HttpParameter p : this.queryParams.values()) {
            builder.addQueryParam(p.getEncodedName(), p.getEncodedValue());
        }
    }

    private void handleBody(RequestBuilder builder) throws IOException {
        if (!this.hasBody()) {
            log.debug("HTTP Request does not have body, skip.");
            return;
        }
        log.debug("Set body to current request builder using: {}", this.body);
        builder.setBody(this.body.getBody());
        if (this.body.getContentType() != null) {
            builder.setHeader("Content-Type", this.body.getContentType());
        }
    }

    private void handleCookies(RequestBuilder builder) {
        if (!this.cookies.isEmpty()) {
            builder.addHeader("Cookie", Cookies.serialize(this.cookies));
        }
    }

    private void handleHeaders(RequestBuilder builder) {
        for (HttpHeader header : this.headers.values()) {
            builder.setHeader(header.getName(), header.serializeValues());
        }
    }
}

