/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client.impl.ning;

import com.github.mjeanroy.junit.servers.client.HttpClientConfiguration;
import com.github.mjeanroy.junit.servers.client.HttpMethod;
import com.github.mjeanroy.junit.servers.client.HttpRequest;
import com.github.mjeanroy.junit.servers.client.HttpUrl;
import com.github.mjeanroy.junit.servers.client.impl.AbstractHttpClient;
import com.github.mjeanroy.junit.servers.client.impl.ning.NingAsyncHttpRequest;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;

public class NingAsyncHttpClient
extends AbstractHttpClient {
    private final AsyncHttpClient client;

    public static NingAsyncHttpClient defaultAsyncHttpClient(EmbeddedServer<?> server) {
        HttpClientConfiguration configuration = HttpClientConfiguration.defaultConfiguration();
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setFollowRedirect(configuration.isFollowRedirect()).build();
        return new NingAsyncHttpClient(configuration, server, new AsyncHttpClient(config));
    }

    public static NingAsyncHttpClient newAsyncHttpClient(HttpClientConfiguration configuration, EmbeddedServer<?> server) {
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setFollowRedirect(configuration.isFollowRedirect()).build();
        AsyncHttpClient client = new AsyncHttpClient(config);
        return new NingAsyncHttpClient(configuration, server, client);
    }

    private NingAsyncHttpClient(HttpClientConfiguration configuration, EmbeddedServer<?> server, AsyncHttpClient client) {
        super(configuration, server);
        this.client = Preconditions.notNull(client, "client");
    }

    @Override
    protected HttpRequest buildRequest(HttpMethod httpMethod, HttpUrl endpoint) {
        return new NingAsyncHttpRequest(this.client, httpMethod, endpoint);
    }

    @Override
    protected void doDestroy() {
        this.client.close();
    }

    @Override
    public boolean isDestroyed() {
        return this.client.isClosed();
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("configuration", this.getConfiguration()).append("server", this.getServer()).append("client", this.client).build();
    }
}

