/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client;

import com.github.mjeanroy.junit.servers.client.HttpRequestBody;
import com.github.mjeanroy.junit.servers.commons.io.Ios;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import java.util.Objects;

final class HttpRequestBodyString
implements HttpRequestBody {
    private final String contentType;
    private final String body;

    static HttpRequestBodyString of(String body) {
        Preconditions.notNull(body, "body");
        return new HttpRequestBodyString(null, body);
    }

    static HttpRequestBodyString of(String body, String contentType) {
        Preconditions.notNull(body, "body");
        Preconditions.notBlank(contentType, "contentType");
        return new HttpRequestBodyString(contentType, body);
    }

    private HttpRequestBodyString(String contentType, String body) {
        this.contentType = contentType;
        this.body = body;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public byte[] getBody() {
        return Ios.toUtf8Bytes(this.body);
    }

    String getBodyString() {
        return this.body;
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("contentType", this.contentType).append("body", this.body).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpRequestBodyString) {
            HttpRequestBodyString b = (HttpRequestBodyString)o;
            return Objects.equals(this.contentType, b.contentType) && Objects.equals(this.body, b.body);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.body);
    }
}

