/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.jupiter;

import com.github.mjeanroy.junit.servers.annotations.TestHttpClient;
import com.github.mjeanroy.junit.servers.client.HttpClientStrategy;
import com.github.mjeanroy.junit.servers.engine.EmbeddedServerTestLifeCycleAdapter;
import com.github.mjeanroy.junit.servers.jupiter.ParameterResolverFunction;
import java.util.function.Function;
import org.junit.jupiter.api.extension.ParameterContext;

class HttpClientParameterResolverFunction
implements ParameterResolverFunction {
    private static final HttpClientParameterResolverFunction INSTANCE = new HttpClientParameterResolverFunction();

    static HttpClientParameterResolverFunction getInstance() {
        return INSTANCE;
    }

    private HttpClientParameterResolverFunction() {
    }

    @Override
    public Object resolve(ParameterContext parameterContext, EmbeddedServerTestLifeCycleAdapter serverAdapter) {
        HttpClientStrategy strategy = HttpClientParameterResolverFunction.getStrategy(parameterContext);
        return serverAdapter.getClient(strategy);
    }

    private static HttpClientStrategy getStrategy(ParameterContext parameterContext) {
        return parameterContext.findAnnotation(TestHttpClient.class).map(new Function<TestHttpClient, HttpClientStrategy>(){

            @Override
            public HttpClientStrategy apply(TestHttpClient testHttpClient) {
                return testHttpClient.strategy();
            }
        }).orElse(HttpClientParameterResolverFunction.defaultStrategy());
    }

    private static HttpClientStrategy defaultStrategy() {
        return HttpClientStrategy.AUTO;
    }
}

