/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.commons;

import com.github.mjeanroy.junit.servers.commons.Strings;
import java.util.Collection;

public final class Preconditions {
    private Preconditions() {
    }

    public static <T> T notNull(T value, String name) {
        if (value == null) {
            throw new NullPointerException(String.format("%s must not be null", name));
        }
        return value;
    }

    public static <T> Collection<T> notEmpty(Collection<T> collection, String name) {
        Preconditions.notNull(collection, name);
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s must not be empty", name));
        }
        return collection;
    }

    public static String notBlank(String value, String name) {
        Preconditions.notNull(value, name);
        if (Strings.isBlank(value)) {
            throw new IllegalArgumentException(String.format("%s must not be blank", name));
        }
        return value;
    }

    public static int positive(int value, String name) {
        return Preconditions.checkPositiveNumber(value, name);
    }

    public static long positive(long value, String name) {
        return Preconditions.checkPositiveNumber(value, name);
    }

    private static <T extends Number> T checkPositiveNumber(T value, String name) {
        if (value.doubleValue() < 0.0) {
            throw new IllegalArgumentException(String.format("%s must be positive", name));
        }
        return value;
    }
}

