/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client.impl.okhttp3;

import com.github.mjeanroy.junit.servers.client.Cookies;
import com.github.mjeanroy.junit.servers.client.HttpHeader;
import com.github.mjeanroy.junit.servers.client.HttpMethod;
import com.github.mjeanroy.junit.servers.client.HttpParameter;
import com.github.mjeanroy.junit.servers.client.HttpRequest;
import com.github.mjeanroy.junit.servers.client.HttpResponse;
import com.github.mjeanroy.junit.servers.client.HttpUrl;
import com.github.mjeanroy.junit.servers.client.impl.AbstractHttpRequest;
import com.github.mjeanroy.junit.servers.client.impl.okhttp3.OkHttpResponseFactory;
import com.github.mjeanroy.junit.servers.commons.ObjectUtils;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

class OkHttpRequest
extends AbstractHttpRequest
implements HttpRequest {
    private final OkHttpClient client;

    OkHttpRequest(OkHttpClient client, HttpMethod httpMethod, HttpUrl endpoint) {
        super(endpoint, httpMethod);
        this.client = client;
    }

    @Override
    protected HttpResponse doExecute() throws Exception {
        HttpUrl endpoint = this.getEndpoint();
        HttpUrl.Builder httpUrlBuilder = new HttpUrl.Builder().scheme(endpoint.getScheme()).host(endpoint.getHost()).port(endpoint.getPort()).addPathSegments(endpoint.getPath().substring(1));
        for (HttpParameter queryParam : this.queryParams.values()) {
            httpUrlBuilder.addEncodedQueryParameter(queryParam.getEncodedName(), queryParam.getEncodedValue());
        }
        Request.Builder builder = new Request.Builder().url(httpUrlBuilder.build());
        this.handleCookies(builder);
        this.handleHeaders(builder);
        this.handleBody(builder);
        Call call = this.client.newCall(builder.build());
        long start = System.nanoTime();
        Response response = call.execute();
        long duration = System.nanoTime() - start;
        return OkHttpResponseFactory.of(response, duration);
    }

    private void handleHeaders(Request.Builder builder) {
        for (HttpHeader h : this.headers.values()) {
            builder.addHeader(h.getName(), h.serializeValues());
        }
    }

    private void handleCookies(Request.Builder builder) {
        if (!this.cookies.isEmpty()) {
            builder.addHeader("Cookie", Cookies.serialize(this.cookies));
        }
    }

    private void handleBody(Request.Builder builder) {
        RequestBody body;
        HttpMethod method = this.getMethod();
        RequestBody requestBody = body = this.hasBody() ? this.createBody() : null;
        if (body == null && method.isBodyAllowed()) {
            body = OkHttpRequest.createEmptyBody();
        }
        builder.method(method.getVerb(), body);
    }

    private RequestBody createBody() {
        RequestBody rqBody = null;
        if (this.body != null && !this.body.isEmpty()) {
            rqBody = RequestBody.create(null, (String)this.body);
        } else if (!this.formParams.isEmpty()) {
            FormBody.Builder builder = new FormBody.Builder();
            for (HttpParameter parameter : this.formParams.values()) {
                String encodedName = parameter.getEncodedName();
                String encodedValue = ObjectUtils.firstNonNull(parameter.getEncodedValue(), "");
                builder.addEncoded(encodedName, encodedValue);
            }
            rqBody = builder.build();
        }
        return rqBody;
    }

    private static RequestBody createEmptyBody() {
        return RequestBody.create(null, (String)"");
    }
}

