/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.tasktracker.support;

import com.github.ltsopensource.core.constant.Constants;
import com.github.ltsopensource.core.exception.JobTrackerNotFoundException;
import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.protocol.JobProtos;
import com.github.ltsopensource.core.protocol.command.JobPullRequest;
import com.github.ltsopensource.ec.EventInfo;
import com.github.ltsopensource.ec.EventSubscriber;
import com.github.ltsopensource.ec.Observer;
import com.github.ltsopensource.jvmmonitor.JVMMonitor;
import com.github.ltsopensource.remoting.exception.RemotingCommandFieldCheckException;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;
import com.github.ltsopensource.tasktracker.domain.TaskTrackerAppContext;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class JobPullMachine {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobPullMachine.class.getSimpleName());
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, new NamedThreadFactory("LTS-JobPullMachine-Executor", true));
    private ScheduledFuture<?> scheduledFuture;
    private AtomicBoolean start = new AtomicBoolean(false);
    private TaskTrackerAppContext appContext;
    private Runnable worker;
    private int jobPullFrequency;
    private boolean machineResCheckEnable = false;

    public JobPullMachine(TaskTrackerAppContext appContext) {
        this.appContext = appContext;
        this.jobPullFrequency = appContext.getConfig().getParameter("job.pull.frequency", 1);
        this.machineResCheckEnable = appContext.getConfig().getParameter("lb.machine.res.check.enable", false);
        appContext.getEventCenter().subscribe(new EventSubscriber(JobPullMachine.class.getSimpleName().concat(appContext.getConfig().getIdentity()), new Observer(){

            @Override
            public void onObserved(EventInfo eventInfo) {
                if ("JOB_TRACKER_AVAILABLE".equals(eventInfo.getTopic())) {
                    JobPullMachine.this.start();
                } else if ("NO_JOB_TRACKER_AVAILABLE".equals(eventInfo.getTopic())) {
                    JobPullMachine.this.stop();
                }
            }
        }), "JOB_TRACKER_AVAILABLE", "NO_JOB_TRACKER_AVAILABLE");
        this.worker = new Runnable(){

            @Override
            public void run() {
                try {
                    if (!JobPullMachine.this.start.get()) {
                        return;
                    }
                    if (!JobPullMachine.this.isMachineResEnough()) {
                        return;
                    }
                    JobPullMachine.this.sendRequest();
                }
                catch (Exception e) {
                    LOGGER.error("Job pull machine run error!", e);
                }
            }
        };
    }

    private void start() {
        try {
            if (this.start.compareAndSet(false, true)) {
                if (this.scheduledFuture == null) {
                    this.scheduledFuture = this.executorService.scheduleWithFixedDelay(this.worker, this.jobPullFrequency * 1000, this.jobPullFrequency * 1000, TimeUnit.MILLISECONDS);
                }
                LOGGER.info("Start Job pull machine success!");
            }
        }
        catch (Throwable t) {
            LOGGER.error("Start Job pull machine failed!", t);
        }
    }

    private void stop() {
        try {
            if (this.start.compareAndSet(true, false)) {
                LOGGER.info("Stop Job pull machine success!");
            }
        }
        catch (Throwable t) {
            LOGGER.error("Stop Job pull machine failed!", t);
        }
    }

    private void sendRequest() throws RemotingCommandFieldCheckException {
        int availableThreads = this.appContext.getRunnerPool().getAvailablePoolSize();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("current availableThreads:{}", availableThreads);
        }
        if (availableThreads == 0) {
            return;
        }
        JobPullRequest requestBody = this.appContext.getCommandBodyWrapper().wrapper(new JobPullRequest());
        requestBody.setAvailableThreads(availableThreads);
        RemotingCommand request = RemotingCommand.createRequestCommand(JobProtos.RequestCode.JOB_PULL.code(), requestBody);
        try {
            RemotingCommand responseCommand = this.appContext.getRemotingClient().invokeSync(request);
            if (responseCommand == null) {
                LOGGER.warn("Job pull request failed! response command is null!");
                return;
            }
            if (JobProtos.ResponseCode.JOB_PULL_SUCCESS.code() == responseCommand.getCode()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Job pull request success!");
                }
                return;
            }
            LOGGER.warn("Job pull request failed! response command is null!");
        }
        catch (JobTrackerNotFoundException e) {
            LOGGER.warn("no job tracker available!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMachineResEnough() {
        if (!this.machineResCheckEnable) {
            return true;
        }
        boolean enough = true;
        try {
            Double cpuRate;
            Double maxCpuTimeRate = this.appContext.getConfig().getParameter("lb.cpuUsedRate.max", 90.0);
            Object processCpuTimeRate = JVMMonitor.getAttribute("com.github.ltsopensource.jvmmonitor:type=JVMThread", "ProcessCpuTimeRate");
            if (processCpuTimeRate != null && (cpuRate = Double.valueOf(Double.valueOf(processCpuTimeRate.toString()) / ((double)Constants.AVAILABLE_PROCESSOR * 1.0))) >= maxCpuTimeRate) {
                LOGGER.info("Pause Pull, CPU USAGE is " + String.format("%.2f", cpuRate) + "% >= " + String.format("%.2f", maxCpuTimeRate) + "%");
                enough = false;
                boolean bl = false;
                return bl;
            }
            Double maxMemoryUsedRate = this.appContext.getConfig().getParameter("lb.memoryUsedRate.max", 90.0);
            Runtime runtime = Runtime.getRuntime();
            long maxMemory = runtime.maxMemory();
            long usedMemory = runtime.totalMemory() - runtime.freeMemory();
            Double memoryUsedRate = new BigDecimal((double)usedMemory / ((double)maxMemory * 1.0), new MathContext(4)).doubleValue();
            if (memoryUsedRate >= maxMemoryUsedRate) {
                LOGGER.info("Pause Pull, MEMORY USAGE is " + memoryUsedRate + " >= " + maxMemoryUsedRate);
                enough = false;
                boolean bl = false;
                return bl;
            }
            enough = true;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.warn("Check Machine Resource error", e);
            boolean bl = true;
            return bl;
        }
        finally {
            Boolean machineResEnough = this.appContext.getConfig().getInternalData("__LTS.INNER.MACHINE.RES.ENOUGH", true);
            if (machineResEnough != enough) {
                this.appContext.getConfig().setInternalData("__LTS.INNER.MACHINE.RES.ENOUGH", enough);
            }
        }
    }
}

