/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.spring;

import com.github.ltsopensource.autoconfigure.PropertiesConfigurationFactory;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.constant.Level;
import com.github.ltsopensource.core.listener.MasterChangeListener;
import com.github.ltsopensource.core.properties.TaskTrackerProperties;
import com.github.ltsopensource.spring.tasktracker.JobDispatcher;
import com.github.ltsopensource.tasktracker.TaskTracker;
import com.github.ltsopensource.tasktracker.TaskTrackerBuilder;
import com.github.ltsopensource.tasktracker.runner.JobRunner;
import com.github.ltsopensource.tasktracker.runner.RunnerFactory;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class TaskTrackerAnnotationFactoryBean
implements FactoryBean<TaskTracker>,
ApplicationContextAware,
InitializingBean,
DisposableBean {
    private ApplicationContext applicationContext;
    private TaskTracker taskTracker;
    private boolean started;
    private String clusterName;
    private String nodeGroup;
    private String registryAddress;
    private String dataPath;
    private int workThreads;
    private Class jobRunnerClass;
    private Level bizLoggerLevel;
    private String jobRunnerBeanName;
    private MasterChangeListener[] masterChangeListeners;
    private String shardField;
    private String identity;
    private String bindIp;
    private Properties configs = new Properties();
    private String[] locations;

    public TaskTracker getObject() throws Exception {
        return this.taskTracker;
    }

    public Class<?> getObjectType() {
        return TaskTracker.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        TaskTrackerProperties properties = null;
        if (this.locations == null || this.locations.length == 0) {
            properties = new TaskTrackerProperties();
            properties.setClusterName(this.clusterName);
            properties.setDataPath(this.dataPath);
            properties.setNodeGroup(this.nodeGroup);
            properties.setRegistryAddress(this.registryAddress);
            properties.setBindIp(this.bindIp);
            properties.setIdentity(this.identity);
            properties.setWorkThreads(this.workThreads);
            properties.setConfigs(CollectionUtils.toMap(this.configs));
            properties.setBizLoggerLevel(this.bizLoggerLevel);
        } else {
            properties = PropertiesConfigurationFactory.createPropertiesConfiguration(TaskTrackerProperties.class, this.locations);
        }
        this.taskTracker = TaskTrackerBuilder.buildByProperties(properties);
        this.registerRunnerBeanDefinition();
        for (Map.Entry<Object, Object> entry : this.configs.entrySet()) {
            this.taskTracker.addConfig(entry.getKey().toString(), entry.getValue().toString());
        }
        this.taskTracker.setRunnerFactory(new RunnerFactory(){

            @Override
            public JobRunner newRunner() {
                return (JobRunner)TaskTrackerAnnotationFactoryBean.this.applicationContext.getBean(TaskTrackerAnnotationFactoryBean.this.jobRunnerBeanName);
            }
        });
        if (this.masterChangeListeners != null) {
            for (MasterChangeListener masterChangeListener : this.masterChangeListeners) {
                this.taskTracker.addMasterChangeListener(masterChangeListener);
            }
        }
    }

    private void registerRunnerBeanDefinition() {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)((ConfigurableApplicationContext)this.applicationContext).getBeanFactory();
        this.jobRunnerBeanName = "LTS_".concat(this.jobRunnerClass.getSimpleName());
        if (!beanFactory.containsBean(this.jobRunnerBeanName)) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((Class)this.jobRunnerClass);
            if (this.jobRunnerClass == JobDispatcher.class) {
                builder.setScope("singleton");
                builder.setLazyInit(false);
                builder.getBeanDefinition().getPropertyValues().addPropertyValue("shardField", (Object)this.shardField);
            } else {
                builder.setScope("prototype");
            }
            beanFactory.registerBeanDefinition(this.jobRunnerBeanName, (BeanDefinition)builder.getBeanDefinition());
        }
    }

    public void start() {
        if (!this.started) {
            this.taskTracker.start();
            this.started = true;
        }
    }

    public void destroy() throws Exception {
        this.taskTracker.stop();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setNodeGroup(String nodeGroup) {
        this.nodeGroup = nodeGroup;
    }

    public void setRegistryAddress(String registryAddress) {
        this.registryAddress = registryAddress;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setWorkThreads(int workThreads) {
        this.workThreads = workThreads;
    }

    public void setJobRunnerClass(Class jobRunnerClass) {
        this.jobRunnerClass = jobRunnerClass;
    }

    public void setMasterChangeListeners(MasterChangeListener ... masterChangeListeners) {
        this.masterChangeListeners = masterChangeListeners;
    }

    public void setBizLoggerLevel(String bizLoggerLevel) {
        if (StringUtils.isNotEmpty(bizLoggerLevel)) {
            this.bizLoggerLevel = Level.valueOf(bizLoggerLevel);
        }
    }

    public void setConfigs(Properties configs) {
        this.configs = configs;
    }

    public void setShardField(String shardField) {
        this.shardField = shardField;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public void setBindIp(String bindIp) {
        this.bindIp = bindIp;
    }

    public void setLocations(String ... locations) {
        this.locations = locations;
    }
}

