/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting.serialize;

import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.spi.ServiceLoader;
import com.github.ltsopensource.remoting.serialize.RemotingSerializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AdaptiveSerializable
implements RemotingSerializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemotingSerializable.class);
    private static volatile String defaultSerializable;
    private static final Map<Integer, RemotingSerializable> ID_SERIALIZABLE_MAP;

    public static RemotingSerializable getSerializableById(int id) {
        return ID_SERIALIZABLE_MAP.get(id);
    }

    public static void setDefaultSerializable(String defaultSerializable) {
        AdaptiveSerializable.defaultSerializable = defaultSerializable;
        LOGGER.info("Using defaultSerializable [{}]", defaultSerializable);
    }

    private RemotingSerializable getRemotingSerializable() {
        String serializable = defaultSerializable;
        RemotingSerializable remotingSerializable = serializable != null ? ServiceLoader.load(RemotingSerializable.class, serializable) : ServiceLoader.loadDefault(RemotingSerializable.class);
        return remotingSerializable;
    }

    @Override
    public int getId() {
        return this.getRemotingSerializable().getId();
    }

    @Override
    public byte[] serialize(Object obj) throws Exception {
        return this.getRemotingSerializable().serialize(obj);
    }

    @Override
    public <T> T deserialize(byte[] data, Class<T> clazz) throws Exception {
        return this.getRemotingSerializable().deserialize(data, clazz);
    }

    static {
        ID_SERIALIZABLE_MAP = new HashMap<Integer, RemotingSerializable>();
        Set<String> names = ServiceLoader.getServiceProviders(RemotingSerializable.class);
        for (String name : names) {
            if ("adaptive".equalsIgnoreCase(name)) continue;
            RemotingSerializable serializable = ServiceLoader.load(RemotingSerializable.class, name);
            ID_SERIALIZABLE_MAP.put(serializable.getId(), serializable);
        }
    }
}

