/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.remoting.netty;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.remoting.AbstractRemotingClient;
import com.github.ltsopensource.remoting.ChannelEventListener;
import com.github.ltsopensource.remoting.ChannelFuture;
import com.github.ltsopensource.remoting.RemotingClientConfig;
import com.github.ltsopensource.remoting.RemotingEvent;
import com.github.ltsopensource.remoting.RemotingEventType;
import com.github.ltsopensource.remoting.common.RemotingHelper;
import com.github.ltsopensource.remoting.exception.RemotingException;
import com.github.ltsopensource.remoting.netty.NettyChannel;
import com.github.ltsopensource.remoting.netty.NettyChannelFuture;
import com.github.ltsopensource.remoting.netty.NettyCodecFactory;
import com.github.ltsopensource.remoting.netty.NettyLogger;
import com.github.ltsopensource.remoting.protocol.RemotingCommand;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;

public class NettyRemotingClient
extends AbstractRemotingClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyRemotingClient.class);
    private final Bootstrap bootstrap = new Bootstrap();
    private final EventLoopGroup eventLoopGroup;
    private DefaultEventExecutorGroup defaultEventExecutorGroup;
    private AppContext appContext;

    public NettyRemotingClient(AppContext appContext, RemotingClientConfig remotingClientConfig) {
        this(remotingClientConfig, null);
        this.appContext = appContext;
    }

    public NettyRemotingClient(RemotingClientConfig remotingClientConfig, ChannelEventListener channelEventListener) {
        super(remotingClientConfig, channelEventListener);
        this.eventLoopGroup = new NioEventLoopGroup(remotingClientConfig.getClientSelectorThreads(), (ThreadFactory)new NamedThreadFactory("NettyClientSelectorThread_", true));
    }

    @Override
    protected void clientStart() throws RemotingException {
        NettyLogger.setNettyLoggerFactory();
        this.defaultEventExecutorGroup = new DefaultEventExecutorGroup(this.remotingClientConfig.getClientWorkerThreads(), (ThreadFactory)new NamedThreadFactory("NettyClientWorkerThread_"));
        final NettyCodecFactory nettyCodecFactory = new NettyCodecFactory(this.appContext, this.getCodec());
        ((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast((EventExecutorGroup)NettyRemotingClient.this.defaultEventExecutorGroup, new ChannelHandler[]{nettyCodecFactory.getEncoder(), nettyCodecFactory.getDecoder(), new IdleStateHandler(NettyRemotingClient.this.remotingClientConfig.getReaderIdleTimeSeconds(), NettyRemotingClient.this.remotingClientConfig.getWriterIdleTimeSeconds(), NettyRemotingClient.this.remotingClientConfig.getClientChannelMaxIdleTimeSeconds()), new NettyConnectManageHandler(), new NettyClientHandler()});
            }
        });
    }

    @Override
    protected void clientShutdown() {
        this.eventLoopGroup.shutdownGracefully();
        if (this.defaultEventExecutorGroup != null) {
            this.defaultEventExecutorGroup.shutdownGracefully();
        }
    }

    @Override
    protected ChannelFuture connect(SocketAddress socketAddress) {
        io.netty.channel.ChannelFuture channelFuture = this.bootstrap.connect(socketAddress);
        return new NettyChannelFuture(channelFuture);
    }

    class NettyConnectManageHandler
    extends ChannelDuplexHandler {
        NettyConnectManageHandler() {
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            String local = localAddress == null ? "UNKNOW" : localAddress.toString();
            String remote = remoteAddress == null ? "UNKNOW" : remoteAddress.toString();
            LOGGER.info("CLIENT : CONNECT  {} => {}", local, remote);
            super.connect(ctx, remoteAddress, localAddress, promise);
            if (NettyRemotingClient.this.channelEventListener != null) {
                assert (remoteAddress != null);
                NettyRemotingClient.this.putRemotingEvent(new RemotingEvent(RemotingEventType.CONNECT, remoteAddress.toString(), new NettyChannel(ctx)));
            }
        }

        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            NettyChannel channel = new NettyChannel(ctx);
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(channel);
            LOGGER.info("CLIENT : DISCONNECT {}", remoteAddress);
            NettyRemotingClient.this.closeChannel(channel);
            super.disconnect(ctx, promise);
            if (NettyRemotingClient.this.channelEventListener != null) {
                NettyRemotingClient.this.putRemotingEvent(new RemotingEvent(RemotingEventType.CLOSE, remoteAddress, channel));
            }
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            NettyChannel channel = new NettyChannel(ctx);
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(channel);
            LOGGER.info("CLIENT : CLOSE {}", remoteAddress);
            NettyRemotingClient.this.closeChannel(channel);
            super.close(ctx, promise);
            if (NettyRemotingClient.this.channelEventListener != null) {
                NettyRemotingClient.this.putRemotingEvent(new RemotingEvent(RemotingEventType.CLOSE, remoteAddress, channel));
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            NettyChannel channel = new NettyChannel(ctx);
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(channel);
            LOGGER.warn("CLIENT : exceptionCaught {}", remoteAddress);
            LOGGER.warn("CLIENT : exceptionCaught exception.", cause);
            NettyRemotingClient.this.closeChannel(channel);
            if (NettyRemotingClient.this.channelEventListener != null) {
                NettyRemotingClient.this.putRemotingEvent(new RemotingEvent(RemotingEventType.EXCEPTION, remoteAddress, channel));
            }
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof IdleStateEvent) {
                IdleStateEvent event = (IdleStateEvent)evt;
                NettyChannel channel = new NettyChannel(ctx);
                String remoteAddress = RemotingHelper.parseChannelRemoteAddr(channel);
                if (event.state().equals((Object)IdleState.ALL_IDLE)) {
                    LOGGER.warn("CLIENT : IDLE [{}]", remoteAddress);
                    NettyRemotingClient.this.closeChannel(channel);
                }
                if (NettyRemotingClient.this.channelEventListener != null) {
                    RemotingEventType remotingEventType = RemotingEventType.valueOf(event.state().name());
                    NettyRemotingClient.this.putRemotingEvent(new RemotingEvent(remotingEventType, remoteAddress, channel));
                }
            }
            ctx.fireUserEventTriggered(evt);
        }
    }

    class NettyClientHandler
    extends SimpleChannelInboundHandler<RemotingCommand> {
        NettyClientHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, RemotingCommand msg) throws Exception {
            NettyRemotingClient.this.processMessageReceived(new NettyChannel(ctx), msg);
        }
    }
}

