/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.queue.mysql;

import com.github.ltsopensource.admin.request.JobQueueReq;
import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.queue.RepeatJobQueue;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.queue.mysql.MysqlSchedulerJobQueue;
import com.github.ltsopensource.queue.mysql.support.RshHolder;
import com.github.ltsopensource.store.jdbc.builder.DeleteSql;
import com.github.ltsopensource.store.jdbc.builder.SelectSql;
import com.github.ltsopensource.store.jdbc.builder.UpdateSql;

public class MysqlRepeatJobQueue
extends MysqlSchedulerJobQueue
implements RepeatJobQueue {
    public MysqlRepeatJobQueue(Config config) {
        super(config);
        this.createTable(this.readSqlFile("sql/mysql/lts_repeat_job_queue.sql", this.getTableName()));
    }

    @Override
    protected String getTableName(JobQueueReq request) {
        return this.getTableName();
    }

    @Override
    public boolean add(JobPo jobPo) {
        return super.add(this.getTableName(), jobPo);
    }

    @Override
    public JobPo getJob(String jobId) {
        return new SelectSql(this.getSqlTemplate()).select().all().from().table(this.getTableName()).where("job_id = ?", jobId).single(RshHolder.JOB_PO_RSH);
    }

    @Override
    public boolean remove(String jobId) {
        return new DeleteSql(this.getSqlTemplate()).delete().from().table(this.getTableName()).where("job_id = ?", jobId).doDelete() == 1;
    }

    @Override
    public JobPo getJob(String taskTrackerNodeGroup, String taskId) {
        return new SelectSql(this.getSqlTemplate()).select().all().from().table(this.getTableName()).where("task_id = ?", taskId).and("task_tracker_node_group = ?", taskTrackerNodeGroup).single(RshHolder.JOB_PO_RSH);
    }

    @Override
    public int incRepeatedCount(String jobId) {
        JobPo jobPo;
        do {
            if ((jobPo = this.getJob(jobId)) != null) continue;
            return -1;
        } while (new UpdateSql(this.getSqlTemplate()).update().table(this.getTableName()).set("repeated_count", jobPo.getRepeatedCount() + 1).where("job_id = ?", jobId).and("repeated_count = ?", jobPo.getRepeatedCount()).doUpdate() != 1);
        return jobPo.getRepeatedCount() + 1;
    }

    @Override
    protected String getTableName() {
        return "lts_repeat_job_queue";
    }
}

