/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.queue.mysql;

import com.github.ltsopensource.admin.response.PaginationRsp;
import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.domain.NodeGroupGetReq;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.queue.NodeGroupStore;
import com.github.ltsopensource.queue.domain.NodeGroupPo;
import com.github.ltsopensource.queue.mysql.support.RshHolder;
import com.github.ltsopensource.store.jdbc.JdbcAbstractAccess;
import com.github.ltsopensource.store.jdbc.builder.DeleteSql;
import com.github.ltsopensource.store.jdbc.builder.InsertSql;
import com.github.ltsopensource.store.jdbc.builder.OrderByType;
import com.github.ltsopensource.store.jdbc.builder.SelectSql;
import com.github.ltsopensource.store.jdbc.builder.WhereSql;
import java.util.List;

public class MysqlNodeGroupStore
extends JdbcAbstractAccess
implements NodeGroupStore {
    public MysqlNodeGroupStore(Config config) {
        super(config);
        this.createTable(this.readSqlFile("sql/mysql/lts_node_group_store.sql", "lts_node_group_store"));
    }

    @Override
    public void addNodeGroup(NodeType nodeType, String name) {
        Long count = (Long)new SelectSql(this.getSqlTemplate()).select().columns("count(1)").from().table(this.getTableName()).where("node_type = ?", nodeType.name()).and("name = ?", name).single();
        if (count > 0L) {
            return;
        }
        new InsertSql(this.getSqlTemplate()).insert(this.getTableName()).columns("node_type", "name", "gmt_created").values(nodeType.name(), name, SystemClock.now()).doInsert();
    }

    @Override
    public void removeNodeGroup(NodeType nodeType, String name) {
        new DeleteSql(this.getSqlTemplate()).delete().from().table(this.getTableName()).where("node_type = ?", nodeType.name()).and("name = ?", name).doDelete();
    }

    @Override
    public List<NodeGroupPo> getNodeGroup(NodeType nodeType) {
        return new SelectSql(this.getSqlTemplate()).select().all().from().table(this.getTableName()).where("node_type = ?", nodeType.name()).list(RshHolder.NODE_GROUP_LIST_RSH);
    }

    @Override
    public PaginationRsp<NodeGroupPo> getNodeGroup(NodeGroupGetReq request) {
        PaginationRsp<NodeGroupPo> response = new PaginationRsp<NodeGroupPo>();
        Long results = (Long)new SelectSql(this.getSqlTemplate()).select().columns("count(1)").from().table(this.getTableName()).whereSql(new WhereSql().andOnNotNull("node_type = ?", request.getNodeType() == null ? null : request.getNodeType().name()).andOnNotEmpty("name = ?", request.getNodeGroup())).single();
        response.setResults(results.intValue());
        if (results == 0L) {
            return response;
        }
        List rows = new SelectSql(this.getSqlTemplate()).select().all().from().table(this.getTableName()).whereSql(new WhereSql().andOnNotNull("node_type = ?", request.getNodeType() == null ? null : request.getNodeType().name()).andOnNotEmpty("name = ?", request.getNodeGroup())).orderBy().column("gmt_created", OrderByType.DESC).limit(request.getStart(), request.getLimit()).list(RshHolder.NODE_GROUP_LIST_RSH);
        response.setRows(rows);
        return response;
    }

    private String getTableName() {
        return "lts_node_group_store";
    }
}

