/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.nio.processor;

import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.nio.NioException;
import com.github.ltsopensource.nio.channel.ChannelInitializer;
import com.github.ltsopensource.nio.channel.NioChannel;
import com.github.ltsopensource.nio.channel.NioChannelImpl;
import com.github.ltsopensource.nio.config.NioServerConfig;
import com.github.ltsopensource.nio.handler.Futures;
import com.github.ltsopensource.nio.handler.NioHandler;
import com.github.ltsopensource.nio.loop.NioSelectorLoop;
import com.github.ltsopensource.nio.processor.AbstractNioProcessor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class NioServerProcessor
extends AbstractNioProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(NioServerProcessor.class);
    private NioServerConfig serverConfig;
    private ServerSocketChannel serverSocketChannel;

    public NioServerProcessor(NioServerConfig serverConfig, NioHandler eventHandler, ChannelInitializer channelInitializer) {
        super(eventHandler, channelInitializer);
        this.serverConfig = serverConfig;
        this.serverSocketChannel = NioServerProcessor.newSocket();
    }

    private static ServerSocketChannel newSocket() {
        try {
            ServerSocketChannel ch = ServerSocketChannel.open();
            ch.configureBlocking(false);
            return ch;
        }
        catch (IOException e) {
            throw new NioException("Open a server socket error:" + e.getMessage(), e);
        }
    }

    @Override
    public NioChannel doAccept(NioSelectorLoop selectorLoop) {
        SocketChannel socketChannel = null;
        NioChannelImpl channel = null;
        try {
            socketChannel = this.serverSocketChannel.accept();
            socketChannel.configureBlocking(false);
            if (this.serverConfig.getTcpNoDelay() != null) {
                socketChannel.socket().setTcpNoDelay(this.serverConfig.getTcpNoDelay());
            }
            if (this.serverConfig.getReceiveBufferSize() != null) {
                socketChannel.socket().setReceiveBufferSize(this.serverConfig.getReceiveBufferSize());
            }
            if (this.serverConfig.getKeepAlive() != null) {
                socketChannel.socket().setKeepAlive(this.serverConfig.getKeepAlive());
            }
            if (this.serverConfig.getReuseAddress() != null) {
                socketChannel.socket().setReuseAddress(this.serverConfig.getReuseAddress());
            }
            if (this.serverConfig.getIpTos() != null) {
                socketChannel.socket().setTrafficClass(this.serverConfig.getIpTos());
            }
            if (this.serverConfig.getOobInline() != null) {
                socketChannel.socket().setOOBInline(this.serverConfig.getOobInline());
            }
            if (this.serverConfig.getSoLinger() != null) {
                socketChannel.socket().setSoLinger(true, this.serverConfig.getSoLinger());
            }
            channel = new NioChannelImpl(selectorLoop, this, socketChannel, this.eventHandler(), this.serverConfig);
            this.channelInitializer.initChannel(channel);
            this.idleDetector.addChannel(channel);
            socketChannel.register(selectorLoop.selector(), 1, channel);
        }
        catch (IOException e) {
            LOGGER.info("accept the connection IOE", e);
        }
        if (channel != null) {
            this.eventHandler().channelConnected(channel);
        }
        return channel;
    }

    @Override
    protected NioChannel doConnect(SocketAddress remoteAddress, NioSelectorLoop selectorLoop, Futures.ConnectFuture connectFuture) {
        throw new UnsupportedOperationException();
    }

    public ServerSocketChannel javaChannel() {
        return this.serverSocketChannel;
    }

    public void register() throws ClosedChannelException {
        this.javaChannel().register(this.acceptSelectorLoop().selector(), 16);
    }

    public void bind(InetSocketAddress localAddress, NioServerConfig config) throws IOException {
        this.javaChannel().socket().bind(localAddress, config.getBacklog());
    }

    protected NioSelectorLoop acceptSelectorLoop() {
        return this.selectorLoop;
    }

    @Override
    public void connect(SelectionKey key) {
        throw new UnsupportedOperationException();
    }
}

