/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.nio.loop;

import com.github.ltsopensource.nio.loop.NioSelectorLoop;
import com.github.ltsopensource.nio.loop.NioSelectorLoopPool;
import com.github.ltsopensource.nio.processor.NioProcessor;
import java.util.concurrent.atomic.AtomicInteger;

public class FixedNioSelectorLoopPool
implements NioSelectorLoopPool {
    private final NioSelectorLoop[] pool;
    private final AtomicInteger nextIndex = new AtomicInteger();

    public FixedNioSelectorLoopPool(int size, String prefix, NioProcessor processor) {
        if (size <= 0) {
            throw new IllegalArgumentException("We can't create a pool with no Selectorloop in it");
        }
        this.pool = new NioSelectorLoop[size];
        for (int i = 0; i < size; ++i) {
            NioSelectorLoop selectorLoop;
            this.pool[i] = selectorLoop = new NioSelectorLoop(prefix + "-NioSelectorLoop-I/O-" + i, processor);
            selectorLoop.start();
        }
    }

    @Override
    public NioSelectorLoop getSelectorLoop() {
        return this.pool[Math.abs(this.nextIndex.incrementAndGet() % this.pool.length)];
    }
}

