/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.nio.handler;

import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.nio.handler.IoFutureListener;
import com.github.ltsopensource.remoting.Future;
import java.util.ArrayList;
import java.util.List;

public class IoFuture
implements Future {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoFuture.class);
    private static final long DEAD_LOCK_CHECK_INTERVAL = 5000L;
    private boolean success = false;
    private Throwable cause;
    private String msg;
    private List<IoFutureListener> listeners;
    private boolean done = false;
    private final Object lock = this;

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Override
    public Throwable cause() {
        return this.cause;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public boolean isDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IoFutureListener listener) {
        if (listener == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<IoFutureListener>();
            }
            this.listeners.add(listener);
            if (this.isDone()) {
                this.complete(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(List<IoFutureListener> listeners) {
        if (listeners == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<IoFutureListener>();
            }
            this.listeners.addAll(listeners);
            if (this.isDone()) {
                for (IoFutureListener listener : listeners) {
                    this.complete(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IoFutureListener listener) {
        if (listener == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners() {
        Object object = this.lock;
        synchronized (object) {
            this.done = true;
            if (this.listeners != null) {
                for (IoFutureListener ioFutureListener : this.listeners) {
                    this.complete(ioFutureListener);
                }
            }
        }
    }

    private void complete(IoFutureListener listener) {
        try {
            listener.operationComplete(this);
        }
        catch (Exception e) {
            LOGGER.error("notify listener {} error ", listener, e);
        }
    }

    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            return this.await0(timeoutMillis, false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean await0(long timeoutMillis, boolean interruptable) throws InterruptedException {
        if (this.isDone()) {
            return true;
        }
        if (timeoutMillis <= 0L) {
            return this.isDone();
        }
        if (interruptable && Thread.interrupted()) {
            throw new InterruptedException(this.toString());
        }
        long endTime = SystemClock.now() + timeoutMillis;
        boolean interrupted = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.isDone()) {
                return true;
            }
            if (timeoutMillis <= 0L) {
                return this.isDone();
            }
            try {
                do {
                    long timeOut = Math.min(timeoutMillis, 5000L);
                    try {
                        this.lock.wait(timeOut);
                    }
                    catch (InterruptedException e) {
                        if (interruptable) {
                            throw e;
                        }
                        interrupted = true;
                    }
                    if (!this.isDone()) continue;
                    boolean bl = true;
                    return bl;
                } while (endTime >= SystemClock.now());
                boolean bl = this.isDone();
                return bl;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

