/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.nio;

import com.github.ltsopensource.nio.NioException;
import com.github.ltsopensource.nio.channel.ChannelInitializer;
import com.github.ltsopensource.nio.config.NioServerConfig;
import com.github.ltsopensource.nio.handler.EmptyHandler;
import com.github.ltsopensource.nio.handler.NioHandler;
import com.github.ltsopensource.nio.processor.NioServerProcessor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;

public class NioServer {
    private NioServerConfig serverConfig;
    private NioServerProcessor processor;
    private NioHandler eventHandler;

    public NioServer(NioServerConfig serverConfig, NioHandler eventHandler, ChannelInitializer channelInitializer) {
        this.serverConfig = serverConfig;
        this.setEventHandler(eventHandler);
        this.processor = new NioServerProcessor(serverConfig, this.eventHandler, channelInitializer);
    }

    private void setEventHandler(NioHandler eventHandler) {
        if (eventHandler == null) {
            eventHandler = new EmptyHandler();
        }
        this.eventHandler = eventHandler;
    }

    public void bind(InetSocketAddress localAddress) {
        this.init();
        this.processor.start();
        try {
            this.processor.register();
        }
        catch (ClosedChannelException e) {
            throw new NioException("register channel error:" + e.getMessage(), e);
        }
        try {
            this.processor.bind(localAddress, this.serverConfig);
        }
        catch (IOException e) {
            throw new NioException("bind channel error:" + e.getMessage(), e);
        }
    }

    private void init() {
        ServerSocketChannel socketChannel = this.processor.javaChannel();
        ServerSocket javaSocket = socketChannel.socket();
        try {
            if (this.serverConfig.getReceiveBufferSize() != null) {
                javaSocket.setReceiveBufferSize(this.serverConfig.getReceiveBufferSize());
            }
            if (this.serverConfig.getReuseAddress() != null) {
                javaSocket.setReuseAddress(this.serverConfig.getReuseAddress());
            }
        }
        catch (SocketException e) {
            throw new NioException("config channel error:" + e.getMessage(), e);
        }
    }

    public void shutdownGracefully() {
    }
}

