/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.monitor.cmd;

import com.github.ltsopensource.cmd.HttpCmdProc;
import com.github.ltsopensource.cmd.HttpCmdRequest;
import com.github.ltsopensource.cmd.HttpCmdResponse;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.domain.monitor.JobClientMData;
import com.github.ltsopensource.core.domain.monitor.JobTrackerMData;
import com.github.ltsopensource.core.domain.monitor.MData;
import com.github.ltsopensource.core.domain.monitor.MNode;
import com.github.ltsopensource.core.domain.monitor.TaskTrackerMData;
import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.core.json.TypeReference;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.monitor.MonitorAppContext;
import java.util.List;

public class MDataAddHttpCmd
implements HttpCmdProc {
    private static final Logger LOGGER = LoggerFactory.getLogger(MDataAddHttpCmd.class);
    private MonitorAppContext appContext;

    public MDataAddHttpCmd(MonitorAppContext appContext) {
        this.appContext = appContext;
    }

    @Override
    public String nodeIdentity() {
        return this.appContext.getConfig().getIdentity();
    }

    @Override
    public String getCommand() {
        return "monitor_data_add_cmd";
    }

    @Override
    public HttpCmdResponse execute(HttpCmdRequest request) throws Exception {
        String mNodeJson = request.getParam("mNode");
        if (StringUtils.isEmpty(mNodeJson)) {
            return HttpCmdResponse.newResponse(false, "mData is empty");
        }
        MNode mNode = (MNode)JSON.parse(mNodeJson, new TypeReference<MNode>(){}.getType());
        HttpCmdResponse response = this.paramCheck(mNode);
        if (response != null) {
            return response;
        }
        String mDataJson = request.getParam("mData");
        if (StringUtils.isEmpty(mDataJson)) {
            return HttpCmdResponse.newResponse(false, "mData is empty");
        }
        try {
            assert (mNode != null);
            List<MData> mDatas = this.getMDataList(mNode.getNodeType(), mDataJson);
            this.appContext.getMDataSrv().addMDatas(mNode, mDatas);
        }
        catch (Exception e) {
            LOGGER.error("Add Monitor Data error: " + JSON.toJSONString(request), e);
            return HttpCmdResponse.newResponse(false, "Add Monitor Data error: " + e.getMessage());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Add Monitor Data success, mNode=" + mNodeJson + ", mData=" + mDataJson);
        }
        return HttpCmdResponse.newResponse(true, "Add Monitor Data success");
    }

    private List<MData> getMDataList(NodeType nodeType, String mDataJson) {
        List mDatas = null;
        if (NodeType.TASK_TRACKER == nodeType) {
            mDatas = (List)JSON.parse(mDataJson, new TypeReference<List<TaskTrackerMData>>(){}.getType());
        } else if (NodeType.JOB_TRACKER == nodeType) {
            mDatas = (List)JSON.parse(mDataJson, new TypeReference<List<JobTrackerMData>>(){}.getType());
        } else if (NodeType.JOB_CLIENT == nodeType) {
            mDatas = (List)JSON.parse(mDataJson, new TypeReference<List<JobClientMData>>(){}.getType());
        }
        return mDatas;
    }

    private HttpCmdResponse paramCheck(MNode mNode) {
        if (mNode == null) {
            return HttpCmdResponse.newResponse(false, "mNode is empty");
        }
        NodeType nodeType = mNode.getNodeType();
        if (nodeType == null || nodeType != NodeType.JOB_CLIENT && nodeType != NodeType.TASK_TRACKER && nodeType != NodeType.JOB_TRACKER) {
            return HttpCmdResponse.newResponse(false, "nodeType error");
        }
        if (StringUtils.isEmpty(mNode.getNodeGroup())) {
            return HttpCmdResponse.newResponse(false, "nodeGroup is empty");
        }
        if (StringUtils.isEmpty(mNode.getIdentity())) {
            return HttpCmdResponse.newResponse(false, "identity is empty");
        }
        return null;
    }
}

