/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.json.bean;

import com.github.ltsopensource.json.bean.FieldSetterInfo;
import com.github.ltsopensource.json.bean.MethodInfo;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class JavaBeanSetterInfo {
    private Class<?> clazz;
    private Constructor<?> constructor;
    private Map<String, MethodInfo> methodSetterInfos;
    private Map<String, FieldSetterInfo> fieldSetterInfos;

    public JavaBeanSetterInfo(Class<?> clazz) {
        this.clazz = clazz;
        Constructor<?> constructor = this.getDefaultConstructor(clazz);
        this.setAccessible(constructor);
        this.constructor = constructor;
        this.methodSetterInfos = this.getMethodSettInfos();
        this.fieldSetterInfos = this.getFiledSetterInfos();
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public Collection<MethodInfo> getMethodSetterInfos() {
        if (this.methodSetterInfos == null) {
            return null;
        }
        return this.methodSetterInfos.values();
    }

    public Collection<FieldSetterInfo> getFieldSetterInfos() {
        if (this.fieldSetterInfos == null) {
            return null;
        }
        return this.fieldSetterInfos.values();
    }

    private Constructor<?> getDefaultConstructor(Class<?> clazz) {
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return null;
        }
        Constructor<?> defaultConstructor = null;
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            defaultConstructor = constructor;
            break;
        }
        if (defaultConstructor == null && clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                if (constructor.getParameterTypes().length != 1 || !constructor.getParameterTypes()[0].equals(clazz.getDeclaringClass())) continue;
                defaultConstructor = constructor;
                break;
            }
        }
        return defaultConstructor;
    }

    private void setAccessible(AccessibleObject obj) {
        if (obj.isAccessible()) {
            return;
        }
        try {
            obj.setAccessible(true);
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    private Map<String, MethodInfo> getMethodSettInfos() {
        HashMap<String, MethodInfo> map = new HashMap<String, MethodInfo>();
        for (Method method : this.clazz.getMethods()) {
            String propertyName;
            String methodName = method.getName();
            if (methodName.length() < 4 || Modifier.isStatic(method.getModifiers()) || !method.getReturnType().equals(Void.TYPE) && !method.getReturnType().equals(this.clazz) || method.getParameterTypes().length != 1 || !methodName.startsWith("set")) continue;
            char c3 = methodName.charAt(3);
            if (Character.isUpperCase(c3)) {
                propertyName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            } else if (c3 == '_') {
                propertyName = methodName.substring(4);
            } else if (c3 == 'f') {
                propertyName = methodName.substring(3);
            } else {
                if (methodName.length() < 5 || !Character.isUpperCase(methodName.charAt(4))) continue;
                propertyName = this.decapitalize(methodName.substring(3));
            }
            Field field = this.getField(this.clazz, propertyName);
            if (field == null && method.getParameterTypes()[0] == Boolean.TYPE) {
                String isFieldName = "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                field = this.getField(this.clazz, isFieldName);
            }
            if (field == null) continue;
            map.put(propertyName, new MethodInfo(propertyName, method));
        }
        return map;
    }

    public Map<String, FieldSetterInfo> getFiledSetterInfos() {
        HashMap<String, FieldSetterInfo> map = new HashMap<String, FieldSetterInfo>();
        for (Field field : this.clazz.getFields()) {
            String propertyName;
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || this.methodSetterInfos.containsKey(propertyName = field.getName())) continue;
            map.put(propertyName, new FieldSetterInfo(propertyName, field));
        }
        return map;
    }

    private String decapitalize(String name) {
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private Field getField(Class<?> clazz, String fieldName) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!fieldName.equals(field.getName())) continue;
            return field;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return this.getField(superClass, fieldName);
        }
        return null;
    }
}

