/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.sender;

import com.github.ltsopensource.biz.logger.domain.JobLogPo;
import com.github.ltsopensource.biz.logger.domain.LogType;
import com.github.ltsopensource.core.constant.Level;
import com.github.ltsopensource.core.json.JSON;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.support.JobDomainConverter;
import com.github.ltsopensource.core.support.SystemClock;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import com.github.ltsopensource.jobtracker.sender.JobPushResult;
import com.github.ltsopensource.queue.domain.JobPo;
import com.github.ltsopensource.store.jdbc.exception.DupEntryException;
import java.util.ArrayList;
import java.util.List;

public class JobSender {
    private final Logger LOGGER = LoggerFactory.getLogger(JobSender.class);
    private JobTrackerAppContext appContext;

    public JobSender(JobTrackerAppContext appContext) {
        this.appContext = appContext;
    }

    public SendResult send(String taskTrackerNodeGroup, String taskTrackerIdentity, int size, SendInvoker invoker) {
        List<JobPo> jobPos = this.fetchJob(taskTrackerNodeGroup, taskTrackerIdentity, size);
        if (jobPos.size() == 0) {
            return new SendResult(false, (Object)JobPushResult.NO_JOB);
        }
        SendResult sendResult = invoker.invoke(jobPos);
        if (sendResult.isSuccess()) {
            ArrayList<JobLogPo> jobLogPos = new ArrayList<JobLogPo>(jobPos.size());
            for (JobPo jobPo : jobPos) {
                JobLogPo jobLogPo = JobDomainConverter.convertJobLog(jobPo);
                jobLogPo.setSuccess(true);
                jobLogPo.setLogType(LogType.SENT);
                jobLogPo.setLogTime(SystemClock.now());
                jobLogPo.setLevel(Level.INFO);
                jobLogPos.add(jobLogPo);
            }
            this.appContext.getJobLogger().log(jobLogPos);
        }
        return sendResult;
    }

    private List<JobPo> fetchJob(String taskTrackerNodeGroup, String taskTrackerIdentity, int size) {
        ArrayList<JobPo> jobPos = new ArrayList<JobPo>(size);
        for (int i = 0; i < size; ++i) {
            JobPo jobPo = this.appContext.getPreLoader().take(taskTrackerNodeGroup, taskTrackerIdentity);
            if (jobPo == null) {
                if (!this.LOGGER.isDebugEnabled()) break;
                this.LOGGER.debug("Job push failed: no job! nodeGroup=" + taskTrackerNodeGroup + ", identity=" + taskTrackerIdentity);
                break;
            }
            try {
                this.appContext.getExecutingJobQueue().add(jobPo);
            }
            catch (DupEntryException e) {
                this.LOGGER.warn("ExecutingJobQueue already exist:" + JSON.toJSONString(jobPo));
                this.appContext.getExecutableJobQueue().resume(jobPo);
                continue;
            }
            this.appContext.getExecutableJobQueue().remove(jobPo.getTaskTrackerNodeGroup(), jobPo.getJobId());
            jobPos.add(jobPo);
        }
        return jobPos;
    }

    public static class SendResult {
        private boolean success;
        private Object returnValue;

        public SendResult(boolean success, Object returnValue) {
            this.success = success;
            this.returnValue = returnValue;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public Object getReturnValue() {
            return this.returnValue;
        }

        public void setReturnValue(Object returnValue) {
            this.returnValue = returnValue;
        }
    }

    public static interface SendInvoker {
        public SendResult invoke(List<JobPo> var1);
    }
}

