/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.jobtracker.monitor;

import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.domain.monitor.JobTrackerMData;
import com.github.ltsopensource.core.domain.monitor.MData;
import com.github.ltsopensource.core.monitor.AbstractMStatReporter;
import com.github.ltsopensource.jobtracker.domain.JobTrackerAppContext;
import java.util.concurrent.atomic.AtomicLong;

public class JobTrackerMStatReporter
extends AbstractMStatReporter {
    private AtomicLong receiveJobNum = new AtomicLong(0L);
    private AtomicLong pushJobNum = new AtomicLong(0L);
    private AtomicLong exeSuccessNum = new AtomicLong(0L);
    private AtomicLong exeFailedNum = new AtomicLong(0L);
    private AtomicLong exeLaterNum = new AtomicLong(0L);
    private AtomicLong exeExceptionNum = new AtomicLong(0L);
    private AtomicLong fixExecutingJobNum = new AtomicLong(0L);

    public JobTrackerMStatReporter(JobTrackerAppContext appContext) {
        super(appContext);
    }

    public void incReceiveJobNum() {
        this.receiveJobNum.incrementAndGet();
    }

    public void incPushJobNum() {
        this.pushJobNum.incrementAndGet();
    }

    public void incPushJobNum(int num) {
        for (int i = 0; i < num; ++i) {
            this.pushJobNum.incrementAndGet();
        }
    }

    public void incExeSuccessNum() {
        this.exeSuccessNum.incrementAndGet();
    }

    public void incExeFailedNum() {
        this.exeFailedNum.incrementAndGet();
    }

    public void incExeLaterNum() {
        this.exeLaterNum.incrementAndGet();
    }

    public void incExeExceptionNum() {
        this.exeExceptionNum.incrementAndGet();
    }

    public void incFixExecutingJobNum() {
        this.fixExecutingJobNum.incrementAndGet();
    }

    @Override
    protected MData collectMData() {
        JobTrackerMData mData = new JobTrackerMData();
        mData.setReceiveJobNum(this.receiveJobNum.getAndSet(0L));
        mData.setExeExceptionNum(this.exeExceptionNum.getAndSet(0L));
        mData.setExeFailedNum(this.exeFailedNum.getAndSet(0L));
        mData.setExeSuccessNum(this.exeSuccessNum.getAndSet(0L));
        mData.setExeLaterNum(this.exeLaterNum.getAndSet(0L));
        mData.setFixExecutingJobNum(this.fixExecutingJobNum.getAndSet(0L));
        mData.setPushJobNum(this.pushJobNum.getAndSet(0L));
        return mData;
    }

    @Override
    protected NodeType getNodeType() {
        return NodeType.JOB_TRACKER;
    }
}

